/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.view.count.model.impl;

import com.liferay.view.count.model.ViewCountEntry;
import com.liferay.view.count.service.ViewCountEntryLocalServiceUtil;

/**
 * The extended model base implementation for the ViewCountEntry service. Represents a row in the &quot;ViewCountEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ViewCountEntryImpl}.
 * </p>
 *
 * @author Preston Crary
 * @see ViewCountEntryImpl
 * @see ViewCountEntry
 * @generated
 */
public abstract class ViewCountEntryBaseImpl
	extends ViewCountEntryModelImpl implements ViewCountEntry {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a view count entry model instance should use the <code>ViewCountEntry</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			ViewCountEntryLocalServiceUtil.addViewCountEntry(this);
		}
		else {
			ViewCountEntryLocalServiceUtil.updateViewCountEntry(this);
		}
	}

}