/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.nio.charset.CharsetDecoderUtil;
import com.liferay.portal.kernel.nio.charset.CharsetEncoderUtil;
import com.liferay.portal.kernel.util.UnicodeFormatter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.BitSet;

public class URLCodec {
    private static final Log _log;
    private static final BitSet _validChars;

    public static String decodeURL(String encodedURLString) {
        return URLCodec.decodeURL(encodedURLString, "UTF-8");
    }

    public static String decodeURL(String encodedURLString, String charsetName) {
        if (encodedURLString == null) {
            return null;
        }
        if (encodedURLString.length() == 0) {
            return "";
        }
        StringBuilder sb = null;
        CharsetDecoder charsetDecoder = null;
        block6: for (int i = 0; i < encodedURLString.length(); ++i) {
            char c = encodedURLString.charAt(i);
            switch (c) {
                case '%': {
                    ByteBuffer byteBuffer = URLCodec._getEncodedByteBuffer(encodedURLString, i);
                    if (charsetDecoder == null) {
                        charsetDecoder = CharsetDecoderUtil.getCharsetDecoder((String)charsetName);
                    }
                    CharBuffer charBuffer = null;
                    try {
                        charBuffer = charsetDecoder.decode(byteBuffer);
                    }
                    catch (CharacterCodingException cce) {
                        _log.error(cce, cce);
                        return "";
                    }
                    if (sb == null) {
                        sb = new StringBuilder(encodedURLString.length());
                        if (i > 0) {
                            sb.append(encodedURLString, 0, i);
                        }
                    }
                    sb.append(charBuffer);
                    i += byteBuffer.capacity() * 3 - 1;
                    continue block6;
                }
                case '+': {
                    if (sb == null) {
                        sb = new StringBuilder(encodedURLString.length());
                        if (i > 0) {
                            sb.append(encodedURLString, 0, i);
                        }
                    }
                    sb.append(' ');
                    continue block6;
                }
                default: {
                    if (sb == null) continue block6;
                    sb.append(c);
                }
            }
        }
        if (sb == null) {
            return encodedURLString;
        }
        return sb.toString();
    }

    public static String encodeURL(String rawURLString) {
        return URLCodec.encodeURL(rawURLString, "UTF-8", false);
    }

    public static String encodeURL(String rawURLString, boolean escapeSpaces) {
        return URLCodec.encodeURL(rawURLString, "UTF-8", escapeSpaces);
    }

    public static String encodeURL(String rawURLString, String charsetName, boolean escapeSpaces) {
        if (rawURLString == null) {
            return null;
        }
        if (rawURLString.isEmpty()) {
            return "";
        }
        StringBuilder sb = null;
        CharsetEncoder charsetEncoder = null;
        char[] hexes = new char[2];
        block12: for (int i = 0; i < rawURLString.length(); ++i) {
            char c = rawURLString.charAt(i);
            if (_validChars.get(c)) {
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            if (sb == null) {
                sb = new StringBuilder(rawURLString.length());
                sb.append(rawURLString, 0, i);
            }
            switch (c) {
                case '/': {
                    sb.append("%2F");
                    continue block12;
                }
                case '=': {
                    sb.append("%3D");
                    continue block12;
                }
                case '&': {
                    sb.append("%26");
                    continue block12;
                }
                case '%': {
                    sb.append("%25");
                    continue block12;
                }
                case ' ': {
                    if (escapeSpaces) {
                        sb.append("%20");
                        continue block12;
                    }
                    sb.append('+');
                    continue block12;
                }
                case '+': {
                    sb.append("%2B");
                    continue block12;
                }
                case ':': {
                    sb.append("%3A");
                    continue block12;
                }
                case '?': {
                    sb.append("%3F");
                    continue block12;
                }
                default: {
                    CharBuffer charBuffer = URLCodec._getRawCharBuffer(rawURLString, i, escapeSpaces);
                    if (charsetEncoder == null) {
                        charsetEncoder = CharsetEncoderUtil.getCharsetEncoder((String)charsetName);
                    }
                    i += charBuffer.length() - 1;
                    ByteBuffer byteBuffer = null;
                    try {
                        byteBuffer = charsetEncoder.encode(charBuffer);
                    }
                    catch (CharacterCodingException cce) {
                        _log.error(cce, cce);
                        return "";
                    }
                    for (int j = byteBuffer.position(); j < byteBuffer.limit(); ++j) {
                        sb.append('%');
                        sb.append(UnicodeFormatter.byteToHex(byteBuffer.get(), hexes, true));
                    }
                }
            }
        }
        if (sb == null) {
            return rawURLString;
        }
        return sb.toString();
    }

    private static int _charToHex(char c) {
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        throw new IllegalArgumentException(c + " is not a hex char");
    }

    private static ByteBuffer _getEncodedByteBuffer(String encodedString, int start) {
        int count = 1;
        for (int i = start + 3; i < encodedString.length() && encodedString.charAt(i) == '%'; i += 3) {
            ++count;
        }
        if (encodedString.length() < start + count * 3) {
            throw new IllegalArgumentException("Invalid URL encoding " + encodedString);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(count);
        for (int i = start; i < start + count * 3; i += 3) {
            int high = URLCodec._charToHex(encodedString.charAt(i + 1));
            int low = URLCodec._charToHex(encodedString.charAt(i + 2));
            byteBuffer.put((byte)((high << 4) + low));
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    private static CharBuffer _getRawCharBuffer(String rawString, int start, boolean escapeSpaces) {
        char rawChar;
        int count = 0;
        for (int i = start; i < rawString.length() && !_validChars.get(rawChar = rawString.charAt(i)) && (escapeSpaces || rawChar != ' '); ++i) {
            ++count;
            if (!Character.isHighSurrogate(rawChar) || i + 1 >= rawString.length() || !Character.isLowSurrogate(rawString.charAt(i + 1))) continue;
            ++i;
            ++count;
        }
        return CharBuffer.wrap(rawString, start, start + count);
    }

    static {
        int i;
        _log = LogFactoryUtil.getLog(URLCodec.class);
        _validChars = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            _validChars.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            _validChars.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            _validChars.set(i);
        }
        _validChars.set(45);
        _validChars.set(95);
        _validChars.set(46);
        _validChars.set(42);
    }
}

