/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.concurrent.ConcurrentHashSet;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ReferenceEntry;
import java.lang.reflect.Field;
import java.util.Set;

public class ReferenceRegistry {
    private static final Log _log = LogFactoryUtil.getLog(ReferenceRegistry.class);
    private static final PACL _pacl = new NoPACL();
    private static final Set<ReferenceEntry> _referenceEntries = new ConcurrentHashSet();

    public static void registerReference(Class<?> clazz, Object object, String fieldName) {
        try {
            ReferenceEntry referenceEntry = _pacl.getReferenceEntry(clazz, object, fieldName);
            _referenceEntries.add(referenceEntry);
        }
        catch (SecurityException se) {
            if (_log.isWarnEnabled()) {
                _log.warn("Not allowed to get field " + fieldName + " for " + clazz);
            }
        }
        catch (Exception e) {
            _log.error("Unable to get field " + fieldName + " for " + clazz);
        }
    }

    public static void registerReference(Class<?> clazz, String fieldName) {
        ReferenceRegistry.registerReference(clazz, null, fieldName);
    }

    public static void registerReference(Field field) {
        ReferenceEntry referenceEntry = new ReferenceEntry(field);
        _referenceEntries.add(referenceEntry);
    }

    public static void registerReference(Object object, Field field) {
        ReferenceEntry referenceEntry = new ReferenceEntry(object, field);
        _referenceEntries.add(referenceEntry);
    }

    public static void releaseReferences() {
        for (ReferenceEntry referenceEntry : _referenceEntries) {
            try {
                referenceEntry.setValue(null);
            }
            catch (Exception e) {
                _log.error("Failed to release reference for " + referenceEntry, e);
            }
        }
        _referenceEntries.clear();
    }

    private static class NoPACL
    implements PACL {
        private NoPACL() {
        }

        @Override
        public ReferenceEntry getReferenceEntry(Class<?> clazz, Object object, String fieldName) throws NoSuchFieldException, SecurityException {
            Field field = clazz.getDeclaredField(fieldName);
            return new ReferenceEntry(object, field);
        }
    }

    public static interface PACL {
        public ReferenceEntry getReferenceEntry(Class<?> var1, Object var2, String var3) throws NoSuchFieldException, SecurityException;
    }
}

