/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usersadmin.atom;

import com.liferay.portal.atom.AtomPager;
import com.liferay.portal.atom.AtomUtil;
import com.liferay.portal.kernel.atom.AtomEntryContent;
import com.liferay.portal.kernel.atom.AtomRequestContext;
import com.liferay.portal.kernel.atom.BaseAtomCollectionAdapter;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.UserServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class UserAtomCollectionAdapter
extends BaseAtomCollectionAdapter<User> {
    private static final String _COLLECTION_NAME = "users";

    public String getCollectionName() {
        return _COLLECTION_NAME;
    }

    public List<String> getEntryAuthors(User user) {
        ArrayList<String> authors = new ArrayList<String>();
        authors.add(user.getFullName());
        return authors;
    }

    public AtomEntryContent getEntryContent(User user, AtomRequestContext atomRequestContext) {
        StringBundler content = new StringBundler();
        content.append(user.getScreenName());
        content.append("\n");
        content.append(user.getEmailAddress());
        content.append("\n");
        content.append(user.getFullName());
        content.append("\n");
        content.append(user.getJobTitle());
        content.append("\n");
        try {
            List userAddresses = user.getAddresses();
            for (Address address : userAddresses) {
                content.append(address.getStreet1());
                content.append("\n");
                content.append(address.getStreet2());
                content.append("\n");
                content.append(address.getStreet3());
                content.append("\n");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return new AtomEntryContent(content.toString());
    }

    public String getEntryId(User user) {
        return String.valueOf(user.getUserId());
    }

    public String getEntrySummary(User user) {
        return user.getFullName();
    }

    public String getEntryTitle(User user) {
        return user.getScreenName();
    }

    public Date getEntryUpdated(User user) {
        return user.getModifiedDate();
    }

    public String getFeedTitle(AtomRequestContext atomRequestContext) {
        String portletId = PortletProviderUtil.getPortletId((String)User.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        return AtomUtil.createFeedTitleFromPortletName(atomRequestContext, portletId);
    }

    protected User doGetEntry(String resourceName, AtomRequestContext atomRequestContext) throws Exception {
        long userId = GetterUtil.getLong((String)resourceName);
        return UserServiceUtil.getUserById((long)userId);
    }

    protected Iterable<User> doGetFeedEntries(AtomRequestContext atomRequestContext) throws Exception {
        long groupId = atomRequestContext.getLongParameter("groupId");
        if (groupId > 0L) {
            List users = UserServiceUtil.getGroupUsers((long)groupId);
            return users;
        }
        long organizationId = atomRequestContext.getLongParameter("organizationId");
        if (organizationId > 0L) {
            List users = UserServiceUtil.getOrganizationUsers((long)organizationId);
            return users;
        }
        long userGroupId = atomRequestContext.getLongParameter("userGroupId");
        if (userGroupId > 0L) {
            List users = UserServiceUtil.getUserGroupUsers((long)userGroupId);
            return users;
        }
        long companyId = CompanyThreadLocal.getCompanyId();
        if (companyId > 0L) {
            int usersCount = UserServiceUtil.getCompanyUsersCount((long)companyId);
            AtomPager atomPager = new AtomPager(atomRequestContext, usersCount);
            AtomUtil.saveAtomPagerInRequest(atomRequestContext, atomPager);
            List users = UserServiceUtil.getCompanyUsers((long)companyId, (int)atomPager.getStart(), (int)(atomPager.getEnd() + 1));
            return users;
        }
        return Collections.emptyList();
    }
}

