/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.message.boards.kernel.model.MBDiscussion;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portlet.messageboards.service.base.MBDiscussionLocalServiceBaseImpl;

public class MBDiscussionLocalServiceImpl
extends MBDiscussionLocalServiceBaseImpl {
    public MBDiscussion addDiscussion(long userId, long groupId, long classNameId, long classPK, long threadId, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long discussionId = this.counterLocalService.increment();
        MBDiscussion discussion = this.mbDiscussionPersistence.create(discussionId);
        discussion.setUuid(serviceContext.getUuid());
        discussion.setGroupId(groupId);
        discussion.setCompanyId(serviceContext.getCompanyId());
        discussion.setUserId(userId);
        discussion.setUserName(user.getFullName());
        discussion.setClassNameId(classNameId);
        discussion.setClassPK(classPK);
        discussion.setThreadId(threadId);
        this.mbDiscussionPersistence.update((BaseModel)discussion);
        return discussion;
    }

    @Deprecated
    public MBDiscussion addDiscussion(long userId, long classNameId, long classPK, long threadId, ServiceContext serviceContext) throws PortalException {
        return this.addDiscussion(userId, serviceContext.getScopeGroupId(), classNameId, classPK, threadId, serviceContext);
    }

    public MBDiscussion fetchDiscussion(long discussionId) {
        return this.mbDiscussionPersistence.fetchByPrimaryKey(discussionId);
    }

    public MBDiscussion fetchDiscussion(String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.mbDiscussionPersistence.fetchByC_C(classNameId, classPK);
    }

    public MBDiscussion fetchThreadDiscussion(long threadId) {
        return this.mbDiscussionPersistence.fetchByThreadId(threadId);
    }

    public MBDiscussion getDiscussion(long discussionId) throws PortalException {
        return this.mbDiscussionPersistence.findByPrimaryKey(discussionId);
    }

    public MBDiscussion getDiscussion(String className, long classPK) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.mbDiscussionPersistence.findByC_C(classNameId, classPK);
    }

    public MBDiscussion getThreadDiscussion(long threadId) throws PortalException {
        return this.mbDiscussionPersistence.findByThreadId(threadId);
    }

    public void subscribeDiscussion(long userId, long groupId, String className, long classPK) throws PortalException {
        this.subscriptionLocalService.addSubscription(userId, groupId, className, classPK);
    }

    public void unsubscribeDiscussion(long userId, String className, long classPK) throws PortalException {
        this.subscriptionLocalService.deleteSubscription(userId, className, classPK);
    }
}

