/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.message.boards.kernel.model.MBCategory;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portlet.messageboards.service.base.MBCategoryServiceBaseImpl;
import com.liferay.portlet.messageboards.service.permission.MBCategoryPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MBCategoryServiceImpl
extends MBCategoryServiceBaseImpl {
    public MBCategory addCategory(long userId, long parentCategoryId, String name, String description, ServiceContext serviceContext) throws PortalException {
        MBCategoryPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), parentCategoryId, "ADD_CATEGORY");
        return this.mbCategoryLocalService.addCategory(userId, parentCategoryId, name, description, serviceContext);
    }

    public MBCategory addCategory(long parentCategoryId, String name, String description, String displayStyle, String emailAddress, String inProtocol, String inServerName, int inServerPort, boolean inUseSSL, String inUserName, String inPassword, int inReadInterval, String outEmailAddress, boolean outCustom, String outServerName, int outServerPort, boolean outUseSSL, String outUserName, String outPassword, boolean mailingListActive, boolean allowAnonymousEmail, ServiceContext serviceContext) throws PortalException {
        MBCategoryPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), parentCategoryId, "ADD_CATEGORY");
        return this.mbCategoryLocalService.addCategory(this.getUserId(), parentCategoryId, name, description, displayStyle, emailAddress, inProtocol, inServerName, inServerPort, inUseSSL, inUserName, inPassword, inReadInterval, outEmailAddress, outCustom, outServerName, outServerPort, outUseSSL, outUserName, outPassword, mailingListActive, allowAnonymousEmail, serviceContext);
    }

    public void deleteCategory(long categoryId, boolean includeTrashedEntries) throws PortalException {
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        MBCategoryPermission.check(this.getPermissionChecker(), category, "DELETE");
        this.mbCategoryLocalService.deleteCategory(category, includeTrashedEntries);
    }

    public void deleteCategory(long groupId, long categoryId) throws PortalException {
        MBCategoryPermission.check(this.getPermissionChecker(), groupId, categoryId, "DELETE");
        this.mbCategoryLocalService.deleteCategory(categoryId);
    }

    public List<MBCategory> getCategories(long groupId) {
        return this.mbCategoryPersistence.filterFindByGroupId(groupId);
    }

    public List<MBCategory> getCategories(long groupId, int status) {
        return this.mbCategoryPersistence.filterFindByG_S(groupId, status);
    }

    public List<MBCategory> getCategories(long groupId, long parentCategoryId, int start, int end) {
        return this.mbCategoryPersistence.filterFindByG_P(groupId, parentCategoryId, start, end);
    }

    public List<MBCategory> getCategories(long groupId, long parentCategoryId, int status, int start, int end) {
        if (status == -1) {
            return this.mbCategoryPersistence.filterFindByG_P(groupId, parentCategoryId, start, end);
        }
        return this.mbCategoryPersistence.filterFindByG_P_S(groupId, parentCategoryId, status, start, end);
    }

    public List<MBCategory> getCategories(long groupId, long excludedCategoryId, long parentCategoryId, int status, int start, int end) {
        if (status == -1) {
            return this.mbCategoryPersistence.filterFindByNotC_G_P(excludedCategoryId, groupId, parentCategoryId, start, end);
        }
        return this.mbCategoryPersistence.filterFindByNotC_G_P_S(excludedCategoryId, groupId, parentCategoryId, status, start, end);
    }

    public List<MBCategory> getCategories(long groupId, long[] parentCategoryIds, int start, int end) {
        return this.mbCategoryPersistence.filterFindByG_P(groupId, parentCategoryIds, start, end);
    }

    public List<MBCategory> getCategories(long groupId, long[] parentCategoryIds, int status, int start, int end) {
        if (status == -1) {
            return this.mbCategoryPersistence.filterFindByG_P(groupId, parentCategoryIds, start, end);
        }
        return this.mbCategoryPersistence.filterFindByG_P_S(groupId, parentCategoryIds, status, start, end);
    }

    public List<MBCategory> getCategories(long groupId, long[] excludedCategoryIds, long[] parentCategoryIds, int status, int start, int end) {
        if (status == -1) {
            return this.mbCategoryPersistence.filterFindByNotC_G_P(excludedCategoryIds, groupId, parentCategoryIds, start, end);
        }
        return this.mbCategoryPersistence.filterFindByNotC_G_P_S(excludedCategoryIds, groupId, parentCategoryIds, status, start, end);
    }

    public List<Object> getCategoriesAndThreads(long groupId, long categoryId) {
        QueryDefinition queryDefinition = new QueryDefinition(-1);
        return this.mbCategoryFinder.filterFindC_T_ByG_C(groupId, categoryId, queryDefinition);
    }

    public List<Object> getCategoriesAndThreads(long groupId, long categoryId, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.mbCategoryFinder.filterFindC_T_ByG_C(groupId, categoryId, queryDefinition);
    }

    public List<Object> getCategoriesAndThreads(long groupId, long categoryId, int status, int start, int end) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        return this.mbCategoryFinder.filterFindC_T_ByG_C(groupId, categoryId, queryDefinition);
    }

    public int getCategoriesAndThreadsCount(long groupId, long categoryId) {
        QueryDefinition queryDefinition = new QueryDefinition(-1);
        return this.mbCategoryFinder.filterCountC_T_ByG_C(groupId, categoryId, queryDefinition);
    }

    public int getCategoriesAndThreadsCount(long groupId, long categoryId, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.mbCategoryFinder.filterCountC_T_ByG_C(groupId, categoryId, queryDefinition);
    }

    public int getCategoriesCount(long groupId, long parentCategoryId) {
        return this.mbCategoryPersistence.filterCountByG_P(groupId, parentCategoryId);
    }

    public int getCategoriesCount(long groupId, long parentCategoryId, int status) {
        if (status == -1) {
            return this.mbCategoryPersistence.filterCountByG_P(groupId, parentCategoryId);
        }
        return this.mbCategoryPersistence.filterCountByG_P_S(groupId, parentCategoryId, status);
    }

    public int getCategoriesCount(long groupId, long excludedCategoryId, long parentCategoryId, int status) {
        if (status == -1) {
            return this.mbCategoryPersistence.filterCountByNotC_G_P(excludedCategoryId, groupId, parentCategoryId);
        }
        return this.mbCategoryPersistence.filterCountByNotC_G_P_S(excludedCategoryId, groupId, parentCategoryId, status);
    }

    public int getCategoriesCount(long groupId, long[] parentCategoryIds) {
        return this.mbCategoryPersistence.filterCountByG_P(groupId, parentCategoryIds);
    }

    public int getCategoriesCount(long groupId, long[] parentCategoryIds, int status) {
        if (status == -1) {
            return this.mbCategoryPersistence.filterCountByG_P(groupId, parentCategoryIds);
        }
        return this.mbCategoryPersistence.filterCountByG_P_S(groupId, parentCategoryIds, status);
    }

    public int getCategoriesCount(long groupId, long[] excludedCategoryIds, long[] parentCategoryIds, int status) {
        if (status == -1) {
            return this.mbCategoryPersistence.filterCountByNotC_G_P(excludedCategoryIds, groupId, parentCategoryIds);
        }
        return this.mbCategoryPersistence.filterCountByNotC_G_P_S(excludedCategoryIds, groupId, parentCategoryIds, status);
    }

    public MBCategory getCategory(long categoryId) throws PortalException {
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        MBCategoryPermission.check(this.getPermissionChecker(), category, "VIEW");
        return category;
    }

    public long[] getCategoryIds(long groupId, long categoryId) {
        ArrayList<Long> categoryIds = new ArrayList<Long>();
        categoryIds.add(categoryId);
        this.getSubcategoryIds(categoryIds, groupId, categoryId);
        return ArrayUtil.toArray((Long[])categoryIds.toArray(new Long[categoryIds.size()]));
    }

    public List<Long> getSubcategoryIds(List<Long> categoryIds, long groupId, long categoryId) {
        List categories = this.mbCategoryPersistence.filterFindByG_P(groupId, categoryId);
        for (MBCategory category : categories) {
            if (category.isInTrash()) continue;
            categoryIds.add(category.getCategoryId());
            this.getSubcategoryIds(categoryIds, category.getGroupId(), category.getCategoryId());
        }
        return categoryIds;
    }

    public List<MBCategory> getSubscribedCategories(long groupId, long userId, int start, int end) {
        long[] categoryIds = this.getCategoryIds(groupId, 0L);
        if (categoryIds.length == 0) {
            return Collections.emptyList();
        }
        QueryDefinition queryDefinition = new QueryDefinition(-1, start, end, null);
        return this.mbCategoryFinder.filterFindC_ByS_G_U_P(groupId, userId, categoryIds, queryDefinition);
    }

    public int getSubscribedCategoriesCount(long groupId, long userId) {
        long[] categoryIds = this.getCategoryIds(groupId, 0L);
        if (categoryIds.length == 0) {
            return 0;
        }
        QueryDefinition queryDefinition = new QueryDefinition(-1);
        return this.mbCategoryFinder.filterCountC_ByS_G_U_P(groupId, userId, categoryIds, queryDefinition);
    }

    public MBCategory moveCategory(long categoryId, long parentCategoryId, boolean mergeWithParentCategory) throws PortalException {
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        MBCategoryPermission.check(this.getPermissionChecker(), category, "UPDATE");
        return this.mbCategoryLocalService.moveCategory(categoryId, parentCategoryId, mergeWithParentCategory);
    }

    public MBCategory moveCategoryFromTrash(long categoryId, long newCategoryId) throws PortalException {
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        MBCategoryPermission.check(this.getPermissionChecker(), category, "UPDATE");
        return this.mbCategoryLocalService.moveCategoryFromTrash(this.getUserId(), categoryId, newCategoryId);
    }

    public MBCategory moveCategoryToTrash(long categoryId) throws PortalException {
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        MBCategoryPermission.check(this.getPermissionChecker(), category, "DELETE");
        return this.mbCategoryLocalService.moveCategoryToTrash(this.getUserId(), categoryId);
    }

    public void restoreCategoryFromTrash(long categoryId) throws PortalException {
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        MBCategoryPermission.check(this.getPermissionChecker(), category, "DELETE");
        this.mbCategoryLocalService.restoreCategoryFromTrash(this.getUserId(), categoryId);
    }

    public void subscribeCategory(long groupId, long categoryId) throws PortalException {
        MBCategoryPermission.check(this.getPermissionChecker(), groupId, categoryId, "SUBSCRIBE");
        this.mbCategoryLocalService.subscribeCategory(this.getUserId(), groupId, categoryId);
    }

    public void unsubscribeCategory(long groupId, long categoryId) throws PortalException {
        MBCategoryPermission.check(this.getPermissionChecker(), groupId, categoryId, "SUBSCRIBE");
        this.mbCategoryLocalService.unsubscribeCategory(this.getUserId(), groupId, categoryId);
    }

    public MBCategory updateCategory(long categoryId, long parentCategoryId, String name, String description, String displayStyle, String emailAddress, String inProtocol, String inServerName, int inServerPort, boolean inUseSSL, String inUserName, String inPassword, int inReadInterval, String outEmailAddress, boolean outCustom, String outServerName, int outServerPort, boolean outUseSSL, String outUserName, String outPassword, boolean mailingListActive, boolean allowAnonymousEmail, boolean mergeWithParentCategory, ServiceContext serviceContext) throws PortalException {
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        MBCategoryPermission.check(this.getPermissionChecker(), category, "UPDATE");
        return this.mbCategoryLocalService.updateCategory(categoryId, parentCategoryId, name, description, displayStyle, emailAddress, inProtocol, inServerName, inServerPort, inUseSSL, inUserName, inPassword, inReadInterval, outEmailAddress, outCustom, outServerName, outServerPort, outUseSSL, outUserName, outPassword, mailingListActive, allowAnonymousEmail, mergeWithParentCategory, serviceContext);
    }
}

