/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.service.permission;

import com.liferay.blogs.kernel.model.BlogsEntry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.BaseResourcePermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;

@OSGiBeanProperties(property={"resource.name=com.liferay.blogs"})
public class BlogsPermission
extends BaseResourcePermissionChecker {
    public static final String RESOURCE_NAME = "com.liferay.blogs";

    public static void check(PermissionChecker permissionChecker, long groupId, String actionId) throws PortalException {
        if (!BlogsPermission.contains(permissionChecker, groupId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker.getUserId(), RESOURCE_NAME, groupId, new String[]{actionId});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long classPK, String actionId) {
        String portletId = PortletProviderUtil.getPortletId((String)BlogsEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        return BlogsPermission.contains((PermissionChecker)permissionChecker, (String)RESOURCE_NAME, (String)portletId, (long)classPK, (String)actionId);
    }

    public Boolean checkResource(PermissionChecker permissionChecker, long classPK, String actionId) {
        return BlogsPermission.contains(permissionChecker, classPK, actionId);
    }
}

