/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow;

import com.liferay.portal.kernel.lock.LockManagerUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowDefinition;
import com.liferay.portal.kernel.workflow.WorkflowException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;

public class WorkflowLockingAdvice {
    private static final String _START_WORKFLOW_INSTANCE_METHOD_NAME = "startWorkflowInstance";
    private static final String _UNDEPLOY_WORKFLOW_DEFINITION_METHOD_NAME = "undeployWorkflowDefinition";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        String key;
        Signature signature = proceedingJoinPoint.getSignature();
        String methodName = signature.getName();
        Object[] arguments = proceedingJoinPoint.getArgs();
        if (methodName.equals(_START_WORKFLOW_INSTANCE_METHOD_NAME)) {
            String key2;
            String workflowDefinitionName = (String)arguments[3];
            Integer workflowDefinitionVersion = (Integer)arguments[4];
            String className = WorkflowDefinition.class.getName();
            if (LockManagerUtil.isLocked((String)className, (String)(key2 = this._encodeKey(workflowDefinitionName, workflowDefinitionVersion)))) {
                throw new WorkflowException("Workflow definition name " + workflowDefinitionName + " and version " + workflowDefinitionVersion + " is being undeployed");
            }
            return proceedingJoinPoint.proceed();
        }
        if (!methodName.equals(_UNDEPLOY_WORKFLOW_DEFINITION_METHOD_NAME)) {
            return proceedingJoinPoint.proceed();
        }
        long userId = (Long)arguments[1];
        String name = (String)arguments[2];
        Integer version = (Integer)arguments[3];
        String className = WorkflowDefinition.class.getName();
        if (LockManagerUtil.isLocked((String)className, (String)(key = this._encodeKey(name, version)))) {
            throw new WorkflowException("Workflow definition name " + name + " and version " + version + " is being undeployed");
        }
        try {
            LockManagerUtil.lock((long)userId, (String)className, (String)key, (String)String.valueOf(userId), (boolean)false, (long)3600000L);
            Object object = proceedingJoinPoint.proceed();
            return object;
        }
        finally {
            LockManagerUtil.unlock((String)className, (String)key);
        }
    }

    private String _encodeKey(String name, int version) {
        return name.concat("#").concat(StringUtil.toHexString((int)version));
    }
}

