/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.impl.ResourcePermissionLocalServiceImpl;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class VerifyPermission
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(VerifyPermission.class);
    private static final List<String> _deprecatedOrganizationActionIds = new ArrayList<String>();

    protected void checkPermissions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List modelNames = ResourceActionsUtil.getModelNames();
            for (String modelName : modelNames) {
                List actionIds = ResourceActionsUtil.getModelResourceActions((String)modelName);
                ResourceActionLocalServiceUtil.checkResourceActions((String)modelName, (List)actionIds, (boolean)true);
            }
            List portletNames = ResourceActionsUtil.getPortletNames();
            for (String portletName : portletNames) {
                List actionIds = ResourceActionsUtil.getPortletResourceActions((String)portletName);
                ResourceActionLocalServiceUtil.checkResourceActions((String)portletName, (List)actionIds, (boolean)true);
            }
        }
    }

    protected void deleteDefaultPrivateLayoutPermissions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long[] companyIds;
            for (long companyId : companyIds = PortalInstances.getCompanyIdsBySQL()) {
                try {
                    this.deleteDefaultPrivateLayoutPermissions_6(companyId);
                }
                catch (Exception e) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)e, (Throwable)e);
                }
            }
        }
    }

    protected void deleteDefaultPrivateLayoutPermissions_6(long companyId) throws Exception {
        Role role = RoleLocalServiceUtil.getRole((long)companyId, (String)"Guest");
        List resourcePermissions = ResourcePermissionLocalServiceUtil.getRoleResourcePermissions((long)role.getRoleId());
        for (ResourcePermission resourcePermission : resourcePermissions) {
            if (!this.isPrivateLayout(resourcePermission.getName(), resourcePermission.getPrimKey())) continue;
            ResourcePermissionLocalServiceUtil.deleteResourcePermission((long)resourcePermission.getResourcePermissionId());
        }
    }

    @Override
    protected void doVerify() throws Exception {
        this.deleteDefaultPrivateLayoutPermissions();
        this.checkPermissions();
        this.fixOrganizationRolePermissions();
        this.fixUserDefaultRolePermissions();
    }

    protected void fixOrganizationRolePermissions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(ResourcePermission.class);
            dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"name", (Object)Organization.class.getName()));
            List resourcePermissions = ResourcePermissionLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
            for (ResourcePermission resourcePermission : resourcePermissions) {
                ResourcePermission groupResourcePermission = null;
                try {
                    groupResourcePermission = ResourcePermissionLocalServiceUtil.getResourcePermission((long)resourcePermission.getCompanyId(), (String)Group.class.getName(), (int)resourcePermission.getScope(), (String)resourcePermission.getPrimKey(), (long)resourcePermission.getRoleId());
                }
                catch (Exception e) {
                    ResourcePermissionLocalServiceUtil.setResourcePermissions((long)resourcePermission.getCompanyId(), (String)Group.class.getName(), (int)resourcePermission.getScope(), (String)resourcePermission.getPrimKey(), (long)resourcePermission.getRoleId(), (String[])ResourcePermissionLocalServiceImpl.EMPTY_ACTION_IDS);
                    groupResourcePermission = ResourcePermissionLocalServiceUtil.getResourcePermission((long)resourcePermission.getCompanyId(), (String)Group.class.getName(), (int)resourcePermission.getScope(), (String)resourcePermission.getPrimKey(), (long)resourcePermission.getRoleId());
                }
                for (String actionId : _deprecatedOrganizationActionIds) {
                    if (!resourcePermission.hasActionId(actionId)) continue;
                    resourcePermission.removeResourceAction(actionId);
                    groupResourcePermission.addResourceAction(actionId);
                }
                try {
                    resourcePermission.resetOriginalValues();
                    ResourcePermissionLocalServiceUtil.updateResourcePermission((ResourcePermission)resourcePermission);
                    groupResourcePermission.resetOriginalValues();
                    ResourcePermissionLocalServiceUtil.updateResourcePermission((ResourcePermission)groupResourcePermission);
                }
                catch (Exception e) {
                    _log.error((Object)e, (Throwable)e);
                }
            }
            PermissionCacheUtil.clearResourceCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void fixUserDefaultRolePermissions() throws Exception {
        DB db = DBManagerUtil.getDB();
        DBType dbType = db.getDBType();
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long userClassNameId = PortalUtil.getClassNameId(User.class);
            long userGroupClassNameId = PortalUtil.getClassNameId(UserGroup.class);
            long[] companyIds = PortalInstances.getCompanyIdsBySQL();
            if (dbType == DBType.MYSQL) {
                this.fixUserDefaultRolePermissionsMySQL(userClassNameId, userGroupClassNameId, companyIds);
                return;
            }
            if (dbType == DBType.ORACLE) {
                this.fixUserDefaultRolePermissionsOracle(userClassNameId, userGroupClassNameId, companyIds);
                return;
            }
            long[] arr$ = companyIds;
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                long companyId = arr$[i$];
                Role powerUserRole = RoleLocalServiceUtil.getRole((long)companyId, (String)"Power User");
                Role userRole = RoleLocalServiceUtil.getRole((long)companyId, (String)"User");
                StringBundler sb = new StringBundler(19);
                sb.append("update ResourcePermission set roleId = ");
                sb.append(userRole.getRoleId());
                sb.append(" where resourcePermissionId in (select ");
                sb.append("resourcePermissionId from ResourcePermission ");
                sb.append("inner join Layout on ResourcePermission.primKey ");
                sb.append("like replace('[$PLID$]_LAYOUT_%', '[$PLID$]', ");
                sb.append("cast_text(Layout.plid)) inner join Group_ on ");
                sb.append("Layout.groupId = Group_.groupId where ");
                sb.append("ResourcePermission.scope = ");
                sb.append(4);
                sb.append(" and ResourcePermission.roleId = ");
                sb.append(powerUserRole.getRoleId());
                sb.append(" and (Group_.classNameId = ");
                sb.append(userClassNameId);
                sb.append(" or Group_.classNameId = ");
                sb.append(userGroupClassNameId);
                sb.append(") and Layout.type_ = '");
                sb.append("portlet");
                sb.append("')");
                this.runSQL(sb.toString());
                ++i$;
            }
            return;
        }
        finally {
            EntityCacheUtil.clearCache();
            FinderCacheUtil.clearCache();
        }
    }

    protected void fixUserDefaultRolePermissionsMySQL(long userClassNameId, long userGroupClassNameId, long[] companyIds) throws Exception {
        for (long companyId : companyIds) {
            Role powerUserRole = RoleLocalServiceUtil.getRole((long)companyId, (String)"Power User");
            Role userRole = RoleLocalServiceUtil.getRole((long)companyId, (String)"User");
            StringBundler sb = new StringBundler(18);
            sb.append("update ResourcePermission inner join Layout on ");
            sb.append("ResourcePermission.primKey like ");
            sb.append("replace('[$PLID$]_LAYOUT_%', '[$PLID$]', ");
            sb.append("cast_text(Layout.plid)) inner join Group_ on ");
            sb.append("Layout.groupId = Group_.groupId set ");
            sb.append("ResourcePermission.roleId = ");
            sb.append(userRole.getRoleId());
            sb.append(" where ResourcePermission.scope = ");
            sb.append(4);
            sb.append(" and ResourcePermission.roleId = ");
            sb.append(powerUserRole.getRoleId());
            sb.append(" and (Group_.classNameId = ");
            sb.append(userClassNameId);
            sb.append(" or Group_.classNameId = ");
            sb.append(userGroupClassNameId);
            sb.append(") and Layout.type_ = '");
            sb.append("portlet");
            sb.append("'");
            this.runSQL(sb.toString());
        }
    }

    protected void fixUserDefaultRolePermissionsOracle(long userClassNameId, long userGroupClassNameId, long[] companyIds) throws Exception {
        try {
            this.runSQL("create table ResourcePermissionPlid (resourcePermissionId LONG null, plid LONG null)");
        }
        catch (SQLException sqle) {
            this.runSQL("delete from ResourcePermissionPlid");
        }
        StringBundler sb = new StringBundler(6);
        sb.append("insert into ResourcePermissionPlid(select ");
        sb.append("ResourcePermission.resourcePermissionId, ");
        sb.append("SUBSTR(ResourcePermission.primKey, 0, ");
        sb.append("INSTR(ResourcePermission.primKey, '_LAYOUT_') -1) as plid ");
        sb.append("from ResourcePermission where ResourcePermission.primKey ");
        sb.append("like '%_LAYOUT_%')");
        this.runSQL(sb.toString());
        for (long companyId : companyIds) {
            Role powerUserRole = RoleLocalServiceUtil.getRole((long)companyId, (String)"Power User");
            Role userRole = RoleLocalServiceUtil.getRole((long)companyId, (String)"User");
            sb = new StringBundler(20);
            sb.append("update ResourcePermission set roleId = ");
            sb.append(userRole.getRoleId());
            sb.append(" where resourcePermissionId in (select ");
            sb.append("ResourcePermission.resourcePermissionId from ");
            sb.append("ResourcePermission inner join ResourcePermissionPlid ");
            sb.append("on ResourcePermission.resourcePermissionId = ");
            sb.append("ResourcePermissionPlid.resourcePermissionId inner ");
            sb.append("join Layout on ResourcePermissionPlid.plid = ");
            sb.append("Layout.plid inner join Group_ on Layout.groupId = ");
            sb.append("Group_.groupId where ResourcePermission.scope = ");
            sb.append(4);
            sb.append(" and ResourcePermission.roleId = ");
            sb.append(powerUserRole.getRoleId());
            sb.append(" and (Group_.classNameId = ");
            sb.append(userClassNameId);
            sb.append(" or Group_.classNameId = ");
            sb.append(userGroupClassNameId);
            sb.append(") and Layout.type_ = '");
            sb.append("portlet");
            sb.append("')");
            this.runSQL(sb.toString());
        }
        this.runSQL("drop table ResourcePermissionPlid");
    }

    protected boolean isPrivateLayout(String name, String primKey) throws Exception {
        long plid;
        Layout layout;
        if (!name.equals(Layout.class.getName()) && !primKey.contains("_LAYOUT_")) {
            return false;
        }
        if (primKey.contains("_LAYOUT_")) {
            primKey = StringUtil.extractFirst((String)primKey, (String)"_LAYOUT_");
        }
        return !(layout = LayoutLocalServiceUtil.getLayout((long)(plid = GetterUtil.getLong((String)primKey)))).isPublicLayout() && !layout.isTypeControlPanel();
    }

    static {
        _deprecatedOrganizationActionIds.add("MANAGE_ARCHIVED_SETUPS");
        _deprecatedOrganizationActionIds.add("MANAGE_LAYOUTS");
        _deprecatedOrganizationActionIds.add("MANAGE_STAGING");
        _deprecatedOrganizationActionIds.add("MANAGE_TEAMS");
        _deprecatedOrganizationActionIds.add("PUBLISH_STAGING");
        _deprecatedOrganizationActionIds.add("APPROVE_PROPOSAL");
        _deprecatedOrganizationActionIds.add("ASSIGN_REVIEWER");
    }
}

