/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.model.impl.LayoutTypeControllerImpl;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class LayoutTypeControllerTracker {
    private static final String[] _LAYOUT_TYPES = new String[]{"embedded", "link_to_layout", "panel", "portlet", "url"};
    private static final LayoutTypeControllerTracker _instance = new LayoutTypeControllerTracker();
    private final Map<String, LayoutTypeController> _defaultLayoutTypeControllers = new ConcurrentHashMap<String, LayoutTypeController>();
    private final ConcurrentMap<String, LayoutTypeController> _layoutTypeControllers = new ConcurrentHashMap<String, LayoutTypeController>();
    private final ServiceTracker<LayoutTypeController, LayoutTypeController> _serviceTracker;

    public static LayoutTypeController getLayoutTypeController(Layout layout) {
        return LayoutTypeControllerTracker.getLayoutTypeController(layout.getType());
    }

    public static LayoutTypeController getLayoutTypeController(String type) {
        return _instance._getLayoutTypeController(type);
    }

    public static Map<String, LayoutTypeController> getLayoutTypeControllers() {
        return Collections.unmodifiableMap(LayoutTypeControllerTracker._instance._layoutTypeControllers);
    }

    public static String[] getTypes() {
        return _instance._getTypes();
    }

    private LayoutTypeControllerTracker() {
        for (String type : _LAYOUT_TYPES) {
            this._defaultLayoutTypeControllers.put(type, new LayoutTypeControllerImpl(type));
        }
        Registry registry = RegistryUtil.getRegistry();
        this._registerDefaults(registry);
        Filter filter = registry.getFilter("(&(layout.type=*)(objectClass=" + LayoutTypeController.class.getName() + "))");
        this._serviceTracker = registry.trackServices(filter, (ServiceTrackerCustomizer)new LayoutTypeControllerServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    private LayoutTypeController _getLayoutTypeController(String type) {
        LayoutTypeController layoutTypeController = (LayoutTypeController)this._layoutTypeControllers.get(type);
        if (layoutTypeController != null) {
            return layoutTypeController;
        }
        return (LayoutTypeController)this._layoutTypeControllers.get("portlet");
    }

    private String[] _getTypes() {
        Set types = this._layoutTypeControllers.keySet();
        return types.toArray(new String[types.size()]);
    }

    private void _registerDefaults(Registry registry) {
        Set<Map.Entry<String, LayoutTypeController>> entries = this._defaultLayoutTypeControllers.entrySet();
        for (Map.Entry<String, LayoutTypeController> entry : entries) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("layout.type", entry.getKey());
            registry.registerService(LayoutTypeController.class, (Object)entry.getValue(), properties);
        }
    }

    private class LayoutTypeControllerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<LayoutTypeController, LayoutTypeController> {
        private LayoutTypeControllerServiceTrackerCustomizer() {
        }

        public LayoutTypeController addingService(ServiceReference<LayoutTypeController> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            LayoutTypeController layoutTypeController = (LayoutTypeController)registry.getService(serviceReference);
            String type = (String)serviceReference.getProperty("layout.type");
            LayoutTypeControllerTracker.this._layoutTypeControllers.put(type, layoutTypeController);
            return layoutTypeController;
        }

        public void modifiedService(ServiceReference<LayoutTypeController> serviceReference, LayoutTypeController layoutTypeController) {
        }

        public void removedService(ServiceReference<LayoutTypeController> serviceReference, LayoutTypeController layoutTypeController) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            String type = (String)serviceReference.getProperty("layout.type");
            if (LayoutTypeControllerTracker.this._defaultLayoutTypeControllers.containsKey(type)) {
                LayoutTypeControllerTracker.this._layoutTypeControllers.replace(type, layoutTypeController, LayoutTypeControllerTracker.this._defaultLayoutTypeControllers.get(type));
            } else {
                LayoutTypeControllerTracker.this._layoutTypeControllers.remove(type);
            }
        }
    }
}

