/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.settings.SettingsDescriptor;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.settings.SettingsFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.upgrade.v7_0_0.util.PortletPreferencesRow;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Enumeration;
import javax.portlet.PortletPreferences;

public abstract class UpgradePortletSettings
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradePortletSettings.class);
    private final SettingsFactory _settingsFactory;

    public UpgradePortletSettings() {
        this._settingsFactory = SettingsFactoryUtil.getSettingsFactory();
    }

    public UpgradePortletSettings(SettingsFactory settingsFactory) {
        this._settingsFactory = settingsFactory;
    }

    protected void addPortletPreferences(PortletPreferencesRow portletPreferencesRow) throws Exception {
        String sql = "insert into PortletPreferences (mvccVersion, portletPreferencesId, ownerId, ownerType, plid, portletId, preferences) values (?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            ps.setLong(1, portletPreferencesRow.getMvccVersion());
            ps.setLong(2, portletPreferencesRow.getPortletPreferencesId());
            ps.setLong(3, portletPreferencesRow.getOwnerId());
            ps.setInt(4, portletPreferencesRow.getOwnerType());
            ps.setLong(5, portletPreferencesRow.getPlid());
            ps.setString(6, portletPreferencesRow.getPortletId());
            ps.setString(7, portletPreferencesRow.getPreferences());
            ps.executeUpdate();
        }
    }

    protected void copyPortletSettingsAsServiceSettings(String portletId, int ownerType, String serviceName) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Copy portlet settings as service settings");
        }
        try (PreparedStatement ps = this.getPortletPreferencesPreparedStatement(portletId, ownerType);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                PortletPreferencesRow portletPreferencesRow = this.getPortletPreferencesRow(rs);
                portletPreferencesRow.setPortletPreferencesId(this.increment());
                portletPreferencesRow.setOwnerType(2);
                portletPreferencesRow.setPortletId(serviceName);
                if (ownerType == 3) {
                    long plid = portletPreferencesRow.getPlid();
                    long groupId = this.getGroupId(plid);
                    portletPreferencesRow.setOwnerId(groupId);
                    portletPreferencesRow.setPlid(0L);
                    if (_log.isInfoEnabled()) {
                        StringBundler sb = new StringBundler(8);
                        sb.append("Copying portlet ");
                        sb.append(portletId);
                        sb.append(" settings from layout ");
                        sb.append(plid);
                        sb.append(" to service ");
                        sb.append(serviceName);
                        sb.append(" in group ");
                        sb.append(groupId);
                        _log.info((Object)sb.toString());
                    }
                }
                this.addPortletPreferences(portletPreferencesRow);
            }
        }
    }

    protected long getGroupId(long plid) throws Exception {
        long groupId = 0L;
        try (PreparedStatement ps = this.connection.prepareStatement("select groupId from Layout where plid = ?");){
            ps.setLong(1, plid);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    groupId = rs.getLong("groupId");
                }
            }
        }
        return groupId;
    }

    protected PreparedStatement getPortletPreferencesPreparedStatement(String portletId, int ownerType) throws Exception {
        PreparedStatement ps = this.connection.prepareStatement("select portletPreferencesId, ownerId, ownerType, plid, portletId, preferences from PortletPreferences where ownerType = ? and portletId = ?");
        ps.setInt(1, ownerType);
        ps.setString(2, portletId);
        return ps;
    }

    protected void resetPortletPreferencesValues(String portletId, int ownerType, SettingsDescriptor settingsDescriptor) throws Exception {
        try (PreparedStatement ps = this.getPortletPreferencesPreparedStatement(portletId, ownerType);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                PortletPreferencesRow portletPreferencesRow = this.getPortletPreferencesRow(rs);
                PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.fromDefaultXML((String)portletPreferencesRow.getPreferences());
                Enumeration names = jxPortletPreferences.getNames();
                block19: while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    for (String key : settingsDescriptor.getAllKeys()) {
                        if (!name.startsWith(key)) continue;
                        jxPortletPreferences.reset(key);
                        continue block19;
                    }
                }
                portletPreferencesRow.setPreferences(PortletPreferencesFactoryUtil.toXML((PortletPreferences)jxPortletPreferences));
                this.updatePortletPreferences(portletPreferencesRow);
            }
        }
    }

    protected void updatePortletPreferences(PortletPreferencesRow portletPreferencesRow) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("update PortletPreferences set mvccVersion = ?, ownerId = ?, ownerType = ?, plid = ?, portletId = ?, preferences = ? where portletPreferencesId = ?");){
            ps.setLong(1, portletPreferencesRow.getMvccVersion());
            ps.setLong(2, portletPreferencesRow.getOwnerId());
            ps.setInt(3, portletPreferencesRow.getOwnerType());
            ps.setLong(4, portletPreferencesRow.getPlid());
            ps.setString(5, portletPreferencesRow.getPortletId());
            ps.setString(6, portletPreferencesRow.getPreferences());
            ps.setLong(7, portletPreferencesRow.getPortletPreferencesId());
            ps.executeUpdate();
        }
    }

    protected void upgradeDisplayPortlet(String portletId, String serviceName, int ownerType) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer(portletId);){
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Upgrading display portlet " + portletId + " settings"));
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Delete service keys from portlet settings");
            }
            SettingsDescriptor settingsDescriptor = this._settingsFactory.getSettingsDescriptor(serviceName);
            this.resetPortletPreferencesValues(portletId, ownerType, settingsDescriptor);
            this.resetPortletPreferencesValues(portletId, 5, settingsDescriptor);
        }
    }

    protected void upgradeMainPortlet(String portletId, String serviceName, int ownerType, boolean resetPortletInstancePreferences) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer(portletId);){
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Upgrading main portlet " + portletId + " settings"));
            }
            this.copyPortletSettingsAsServiceSettings(portletId, ownerType, serviceName);
            if (resetPortletInstancePreferences) {
                SettingsDescriptor portletInstanceSettingsDescriptor = this._settingsFactory.getSettingsDescriptor(portletId);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Delete portlet instance keys from service settings");
                }
                this.resetPortletPreferencesValues(serviceName, 2, portletInstanceSettingsDescriptor);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Delete service keys from portlet settings");
            }
            SettingsDescriptor serviceSettingsDescriptor = this._settingsFactory.getSettingsDescriptor(serviceName);
            this.resetPortletPreferencesValues(portletId, ownerType, serviceSettingsDescriptor);
            this.resetPortletPreferencesValues(portletId, 5, serviceSettingsDescriptor);
        }
    }

    private PortletPreferencesRow getPortletPreferencesRow(ResultSet rs) throws Exception {
        return new PortletPreferencesRow(rs.getLong("portletPreferencesId"), rs.getLong("ownerId"), rs.getInt("ownerType"), rs.getLong("plid"), rs.getString("portletId"), rs.getString("preferences"));
    }
}

