/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_0_0;

import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.upgrade.BaseUpgradePortletPreferences;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import javax.portlet.PortletPreferences;

public class UpgradeAssetPublisher
extends BaseUpgradePortletPreferences {
    protected String[] getAssetEntryXmls(String[] manualEntries) throws Exception {
        String[] assetEntryXmls = new String[manualEntries.length];
        for (int i = 0; i < manualEntries.length; ++i) {
            String manualEntry = manualEntries[i];
            Document document = SAXReaderUtil.read((String)manualEntry);
            Element rootElement = document.getRootElement();
            this.upgradeToAssetEntryIdElement(rootElement);
            this.upgradeToAssetEntryTypeElement(rootElement);
            assetEntryXmls[i] = document.formattedString("");
        }
        return assetEntryXmls;
    }

    protected String[] getPortletIds() {
        return new String[]{"101_INSTANCE_%"};
    }

    protected String getUpdatePortletPreferencesWhereClause() {
        StringBundler sb = new StringBundler(5);
        sb.append("(portletId like '101_INSTANCE_%') and ((preferences like ");
        sb.append("'%<preference><name>selection-style</name><value>manual");
        sb.append("</value></preference>%') OR (preferences like ");
        sb.append("'%<preference><name>selectionStyle</name><value>manual");
        sb.append("</value></preference>%'))");
        return sb.toString();
    }

    protected String upgradePreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws Exception {
        Object[] manualEntries;
        Object[] assetEntryXmls;
        String selectionStyle;
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        long layoutId = GetterUtil.getLong((String)portletPreferences.getValue("lfr-scope-layout-id", null));
        portletPreferences.reset("lfr-scope-layout-id");
        if (layoutId != 0L) {
            portletPreferences.setValues("scope-ids", new String[]{"Layout_" + layoutId});
            portletPreferences.setValue("default-scope", Boolean.FALSE.toString());
        }
        long classNameId = GetterUtil.getLong((String)portletPreferences.getValue("class-name-id", null));
        portletPreferences.reset("class-name-id");
        if (classNameId != 0L) {
            portletPreferences.setValues("class-name-ids", new String[]{String.valueOf(classNameId)});
            portletPreferences.setValue("any-asset-type", Boolean.FALSE.toString());
        }
        boolean andOperator = GetterUtil.getBoolean((String)portletPreferences.getValue("and-operator", null));
        portletPreferences.reset("and-operator");
        String[] assetTagNames = portletPreferences.getValues("entries", null);
        String[] notAssetTagNames = portletPreferences.getValues("not-entries", null);
        int i = 0;
        if (assetTagNames != null) {
            portletPreferences.reset("entries");
            portletPreferences.setValue("queryContains" + i, Boolean.TRUE.toString());
            portletPreferences.setValue("queryAndOperator" + i, String.valueOf(andOperator));
            portletPreferences.setValue("queryName" + i, "assetTags");
            portletPreferences.setValues("queryValues" + i, assetTagNames);
            ++i;
        }
        if (notAssetTagNames != null) {
            portletPreferences.reset("not-entries");
            portletPreferences.setValue("queryContains" + i, Boolean.FALSE.toString());
            portletPreferences.setValue("queryAndOperator" + i, String.valueOf(andOperator));
            portletPreferences.setValue("queryName" + i, "assetTags");
            portletPreferences.setValues("queryValues" + i, notAssetTagNames);
            ++i;
        }
        if (Validator.isNotNull((String)(selectionStyle = portletPreferences.getValue("selection-style", null))) && !selectionStyle.equals("dynamic")) {
            String[] manualEntries2 = portletPreferences.getValues("manual-entries", new String[0]);
            String[] assetEntryXmls2 = this.getAssetEntryXmls(manualEntries2);
            portletPreferences.setValues("asset-entry-xml", assetEntryXmls2);
        }
        if (ArrayUtil.isEmpty((Object[])(assetEntryXmls = portletPreferences.getValues("asset-entry-xml", new String[0])))) {
            assetEntryXmls = portletPreferences.getValues("assetEntryXml", new String[0]);
        }
        if (ArrayUtil.isEmpty((Object[])(manualEntries = portletPreferences.getValues("manual-entries", new String[0])))) {
            manualEntries = portletPreferences.getValues("manualEntries", new String[0]);
        }
        if (ArrayUtil.isEmpty((Object[])assetEntryXmls) && ArrayUtil.isNotEmpty((Object[])manualEntries)) {
            assetEntryXmls = this.getAssetEntryXmls((String[])manualEntries);
            portletPreferences.setValues("asset-entry-xml", (String[])assetEntryXmls);
        }
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferences);
    }

    protected void upgradeToAssetEntryIdElement(Element rootElement) {
        Element assetIdElement = rootElement.element("asset-id");
        if (assetIdElement != null) {
            String assetEntryId = assetIdElement.getText();
            Element assetEntryIdElement = rootElement.addElement("assetEntryId");
            assetEntryIdElement.addText(assetEntryId);
            rootElement.remove(assetIdElement);
        }
    }

    protected void upgradeToAssetEntryTypeElement(Element rootElement) {
        Element assetTypeElement = rootElement.element("asset-type");
        if (assetTypeElement != null) {
            String assetEntryType = assetTypeElement.getText();
            Element assetEntryTypeElement = rootElement.addElement("assetEntryType");
            assetEntryTypeElement.addText(assetEntryType);
            rootElement.remove(assetTypeElement);
        }
    }
}

