/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import java.io.InputStream;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.List;

public class UpgradeMVCCVersion
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeMVCCVersion.class);

    public void upgradeMVCCVersion(DatabaseMetaData databaseMetaData, String tableName) throws Exception {
        for (String excludeTableName : this.getExcludedTableNames()) {
            if (!StringUtil.equalsIgnoreCase((String)excludeTableName, (String)tableName)) continue;
            return;
        }
        tableName = this.normalizeName(tableName, databaseMetaData);
        try (ResultSet tableResultSet = databaseMetaData.getTables(null, null, tableName, null);){
            if (!tableResultSet.next()) {
                _log.error((Object)("Table " + tableName + " does not exist"));
                return;
            }
            try (ResultSet columnResultSet = databaseMetaData.getColumns(null, null, tableName, this.normalizeName("mvccVersion", databaseMetaData));){
                if (columnResultSet.next()) {
                    return;
                }
                this.runSQL("alter table " + tableName + " add mvccVersion LONG default 0 not null");
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Added column mvccVersion to table " + tableName));
                }
            }
        }
    }

    protected void doUpgrade() throws Exception {
        this.upgradeClassElementMVCCVersions();
        this.upgradeModuleTableMVCCVersions();
    }

    protected List<Element> getClassElements() throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("META-INF/portal-hbm.xml");
        Document document = UnsecureSAXReaderUtil.read((InputStream)inputStream);
        Element rootElement = document.getRootElement();
        return rootElement.elements("class");
    }

    protected String[] getExcludedTableNames() {
        return new String[0];
    }

    protected String[] getModuleTableNames() {
        return new String[]{"BackgroundTask", "Lock_"};
    }

    protected void upgradeClassElementMVCCVersions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            DatabaseMetaData databaseMetaData = this.connection.getMetaData();
            List<Element> classElements = this.getClassElements();
            for (Element classElement : classElements) {
                if (classElement.element("version") == null) continue;
                this.upgradeMVCCVersion(databaseMetaData, classElement);
            }
        }
    }

    protected void upgradeModuleTableMVCCVersions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            String[] moduleTableNames;
            DatabaseMetaData databaseMetaData = this.connection.getMetaData();
            for (String moduleTableName : moduleTableNames = this.getModuleTableNames()) {
                this.upgradeMVCCVersion(databaseMetaData, moduleTableName);
            }
        }
    }

    protected void upgradeMVCCVersion(DatabaseMetaData databaseMetaData, Element classElement) throws Exception {
        String tableName = classElement.attributeValue("table");
        this.upgradeMVCCVersion(databaseMetaData, tableName);
    }
}

