/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.struts;

import com.liferay.portal.kernel.concurrent.ConcurrentHashSet;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.StringServiceRegistrationMap;
import com.liferay.registry.collections.StringServiceRegistrationMapImpl;
import com.liferay.registry.util.StringPlus;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class AuthPublicPathRegistry {
    private static final AuthPublicPathRegistry _instance = new AuthPublicPathRegistry();
    private final Set<String> _paths = new ConcurrentHashSet();
    private final StringServiceRegistrationMap<Object> _serviceRegistrations = new StringServiceRegistrationMapImpl();
    private final ServiceTracker<Object, Object> _serviceTracker;

    public static boolean contains(String path) {
        return _instance._contains(path);
    }

    public static void register(String ... paths) {
        _instance._register(paths);
    }

    public static void unregister(String ... paths) {
        _instance._unregister(paths);
    }

    private AuthPublicPathRegistry() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(registry.getFilter("(&(auth.public.path=*)(objectClass=java.lang.Object))"), (ServiceTrackerCustomizer)new AuthPublicTrackerCustomizer());
        this._serviceTracker.open();
    }

    private boolean _contains(String path) {
        return this._paths.contains(path);
    }

    private void _register(String ... paths) {
        Registry registry = RegistryUtil.getRegistry();
        for (String path : paths) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("auth.public.path", path);
            properties.put("objectClass", Object.class.getName());
            ServiceRegistration serviceRegistration = registry.registerService(Object.class, new Object(), properties);
            this._serviceRegistrations.put((Object)path, (Object)serviceRegistration);
        }
    }

    private void _unregister(String ... paths) {
        for (String path : paths) {
            ServiceRegistration serviceRegistration = (ServiceRegistration)this._serviceRegistrations.remove((Object)path);
            if (serviceRegistration == null) continue;
            serviceRegistration.unregister();
        }
    }

    private class AuthPublicTrackerCustomizer
    implements ServiceTrackerCustomizer<Object, Object> {
        private AuthPublicTrackerCustomizer() {
        }

        public Object addingService(ServiceReference<Object> serviceReference) {
            List paths = StringPlus.asList((Object)serviceReference.getProperty("auth.public.path"));
            for (String path : paths) {
                AuthPublicPathRegistry.this._paths.add(path);
            }
            Registry registry = RegistryUtil.getRegistry();
            return registry.getService(serviceReference);
        }

        public void modifiedService(ServiceReference<Object> serviceReference, Object object) {
        }

        public void removedService(ServiceReference<Object> serviceReference, Object object) {
            List paths = StringPlus.asList((Object)serviceReference.getProperty("auth.public.path"));
            for (String path : paths) {
                AuthPublicPathRegistry.this._paths.remove(path);
            }
        }
    }
}

