/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.spring.aop.Skip;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.ClassNameImpl;
import com.liferay.portal.service.base.ClassNameLocalServiceBaseImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClassNameLocalServiceImpl
extends ClassNameLocalServiceBaseImpl
implements CacheRegistryItem {
    private static final Map<String, ClassName> _classNames = new ConcurrentHashMap<String, ClassName>();
    private static final ClassName _nullClassName = new ClassNameImpl();

    public ClassName addClassName(String value) {
        ClassName className = this.classNamePersistence.fetchByValue(value);
        if (className == null) {
            long classNameId = this.counterLocalService.increment();
            className = this.classNamePersistence.create(classNameId);
            className.setValue(value);
            this.classNamePersistence.update((BaseModel)className);
        }
        return className;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void checkClassNames() {
        List classNames = this.classNamePersistence.findAll();
        for (ClassName className : classNames) {
            _classNames.put(className.getValue(), className);
        }
        List models = ModelHintsUtil.getModels();
        for (String model : models) {
            this.getClassName(model);
        }
    }

    public ClassName fetchClassName(String value) {
        if (Validator.isNull((String)value)) {
            return _nullClassName;
        }
        ClassName className = _classNames.get(value);
        if (className == null) {
            className = this.classNamePersistence.fetchByValue(value);
            if (className == null) {
                return _nullClassName;
            }
            _classNames.put(value, className);
        }
        return className;
    }

    @Skip
    public ClassName getClassName(String value) {
        ClassName className;
        block4: {
            if (Validator.isNull((String)value)) {
                return _nullClassName;
            }
            className = _classNames.get(value);
            if (className == null) {
                try {
                    className = this.classNameLocalService.addClassName(value);
                    _classNames.put(value, className);
                }
                catch (Throwable t) {
                    className = this.classNameLocalService.fetchClassName(value);
                    if (className != _nullClassName) break block4;
                    throw t;
                }
            }
        }
        return className;
    }

    @Skip
    public long getClassNameId(Class<?> clazz) {
        return this.getClassNameId(clazz.getName());
    }

    @Skip
    public long getClassNameId(String value) {
        ClassName className = this.getClassName(value);
        return className.getClassNameId();
    }

    public String getRegistryName() {
        return ClassNameLocalServiceImpl.class.getName();
    }

    public void invalidate() {
        _classNames.clear();
    }
}

