/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pwd;

import com.liferay.portal.kernel.exception.PwdEncryptorException;
import com.liferay.portal.kernel.security.pwd.PasswordEncryptor;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;

public abstract class BasePasswordEncryptor
implements PasswordEncryptor {
    private static final String _PASSWORDS_ENCRYPTION_ALGORITHM = StringUtil.toUpperCase((String)GetterUtil.getString((String)PropsUtil.get("passwords.encryption.algorithm")));

    public String encrypt(String plainTextPassword, String encryptedPassword) throws PwdEncryptorException {
        return this.encrypt(this.getDefaultPasswordAlgorithmType(), plainTextPassword, encryptedPassword);
    }

    public String encrypt(String algorithm, String plainTextPassword, String encryptedPassword) throws PwdEncryptorException {
        if (Validator.isNull((String)plainTextPassword)) {
            throw new PwdEncryptorException("Unable to encrypt blank password");
        }
        return this.doEncrypt(algorithm, plainTextPassword, encryptedPassword);
    }

    public String getDefaultPasswordAlgorithmType() {
        return _PASSWORDS_ENCRYPTION_ALGORITHM;
    }

    protected abstract String doEncrypt(String var1, String var2, String var3) throws PwdEncryptorException;
}

