/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth.tunnel;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.security.auth.RemoteAuthException;
import com.liferay.portal.kernel.security.auth.http.HttpAuthManagerUtil;
import com.liferay.portal.kernel.security.auth.http.HttpAuthorizationHeader;
import com.liferay.portal.kernel.security.auth.tunnel.TunnelAuthenticationManager;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.Encryptor;
import com.liferay.util.EncryptorException;
import java.net.HttpURLConnection;
import java.security.Key;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class TunnelAuthenticationManagerImpl
implements TunnelAuthenticationManager {
    private static final Log _log = LogFactoryUtil.getLog(TunnelAuthenticationManagerImpl.class);

    public long getUserId(HttpServletRequest httpServletRequest) throws AuthException {
        long companyId;
        HttpAuthorizationHeader httpAuthorizationHeader = HttpAuthManagerUtil.parse((HttpServletRequest)httpServletRequest);
        if (httpAuthorizationHeader == null) {
            return 0L;
        }
        String scheme = httpAuthorizationHeader.getScheme();
        if (!StringUtil.equalsIgnoreCase((String)scheme, (String)"Basic")) {
            RemoteAuthException authException = new RemoteAuthException("Invalid scheme " + scheme);
            authException.setType(1);
            throw authException;
        }
        String expectedPassword = null;
        String login = httpAuthorizationHeader.getAuthParameter("username");
        try {
            expectedPassword = Encryptor.encrypt((Key)this.getSharedSecretKey(), (String)login);
        }
        catch (EncryptorException ee) {
            RemoteAuthException authException = new RemoteAuthException((Throwable)ee);
            authException.setType(1);
            throw authException;
        }
        catch (AuthException ae) {
            RemoteAuthException authException = new RemoteAuthException((Throwable)ae);
            authException.setType(ae.getType());
            throw authException;
        }
        String password = httpAuthorizationHeader.getAuthParameter("password");
        if (!Validator.equals((Object)expectedPassword, (Object)password)) {
            RemoteAuthException authException = new RemoteAuthException();
            authException.setType(101);
            throw authException;
        }
        User user = UserLocalServiceUtil.fetchUser((long)GetterUtil.getLong((String)login));
        if (user == null && (user = UserLocalServiceUtil.fetchUserByEmailAddress((long)(companyId = PortalInstances.getCompanyId(httpServletRequest)), (String)login)) == null) {
            user = UserLocalServiceUtil.fetchUserByScreenName((long)companyId, (String)login);
        }
        if (user == null) {
            RemoteAuthException authException = new RemoteAuthException("Unable to find user " + login);
            authException.setType(1);
            throw authException;
        }
        return user.getUserId();
    }

    public void setCredentials(String login, HttpURLConnection httpURLConnection) throws Exception {
        if (Validator.isBlank((String)login)) {
            throw new IllegalArgumentException("Login is null");
        }
        HttpAuthorizationHeader httpAuthorizationHeader = new HttpAuthorizationHeader("Basic");
        String password = Encryptor.encrypt((Key)this.getSharedSecretKey(), (String)login);
        httpAuthorizationHeader.setAuthParameter("password", password);
        httpAuthorizationHeader.setAuthParameter("username", login);
        httpURLConnection.setRequestProperty("Authorization", httpAuthorizationHeader.toString());
    }

    protected Key getSharedSecretKey() throws AuthException {
        String sharedSecret = PropsValues.TUNNELING_SERVLET_SHARED_SECRET;
        boolean sharedSecretHex = PropsValues.TUNNELING_SERVLET_SHARED_SECRET_HEX;
        if (Validator.isNull((String)sharedSecret)) {
            String message = "Please configure tunneling.servlet.shared.secret";
            if (_log.isWarnEnabled()) {
                _log.warn((Object)message);
            }
            AuthException authException = new AuthException(message);
            authException.setType(3);
            throw authException;
        }
        byte[] key = null;
        if (sharedSecretHex) {
            try {
                key = Hex.decodeHex((char[])sharedSecret.toCharArray());
            }
            catch (DecoderException de) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)de, (Throwable)de);
                }
                AuthException authException = new AuthException();
                authException.setType(2);
                throw authException;
            }
        } else {
            key = sharedSecret.getBytes();
        }
        if (key.length < 8) {
            String message = "tunneling.servlet.shared.secret is too short";
            if (_log.isWarnEnabled()) {
                _log.warn((Object)message);
            }
            AuthException authException = new AuthException(message);
            authException.setType(2);
            throw authException;
        }
        if (StringUtil.equalsIgnoreCase((String)PropsValues.TUNNELING_SERVLET_ENCRYPTION_ALGORITHM, (String)"AES") && key.length != 16 && key.length != 32) {
            String message = "tunneling.servlet.shared.secret must have 16 or 32 bytes when used with AES";
            if (_log.isWarnEnabled()) {
                _log.warn((Object)message);
            }
            AuthException authException = new AuthException(message);
            authException.setType(2);
            throw authException;
        }
        return new SecretKeySpec(key, PropsValues.TUNNELING_SERVLET_ENCRYPTION_ALGORITHM);
    }
}

