/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.resiliency.service;

import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiServiceInvokerUtil;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.rpc.IntrabandRPCUtil;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.resiliency.spi.SPI;
import com.liferay.portal.kernel.resiliency.spi.SPIRegistryUtil;
import com.liferay.portal.kernel.security.access.control.AccessControl;
import com.liferay.portal.kernel.security.access.control.AccessControlThreadLocal;
import com.liferay.portal.kernel.security.access.control.AccessControlled;
import com.liferay.portal.kernel.util.ClassLoaderPool;
import com.liferay.portal.resiliency.service.ServiceMethodProcessCallable;
import com.liferay.portal.spring.aop.AnnotationChainableMethodAdvice;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;

public class PortalResiliencyAdvice
extends AnnotationChainableMethodAdvice<AccessControlled> {
    @Override
    public Object before(MethodInvocation methodInvocation) throws Throwable {
        AccessControlled accessControlled = (AccessControlled)this.findAnnotation(methodInvocation);
        if (accessControlled == AccessControl.NULL_ACCESS_CONTROLLED) {
            return null;
        }
        boolean remoteAccess = AccessControlThreadLocal.isRemoteAccess();
        if (!remoteAccess) {
            return null;
        }
        Object targetObject = methodInvocation.getThis();
        Class<?> targetClass = targetObject.getClass();
        String servletContextName = ClassLoaderPool.getContextName((ClassLoader)targetClass.getClassLoader());
        SPI spi = SPIRegistryUtil.getServletContextSPI((String)servletContextName);
        if (spi == null) {
            this.serviceBeanAopCacheManager.removeMethodInterceptor(methodInvocation, this);
            return null;
        }
        ServiceMethodProcessCallable serviceMethodProcessCallable = new ServiceMethodProcessCallable(IdentifiableOSGiServiceInvokerUtil.createMethodHandler((Object)methodInvocation.getThis(), (Method)methodInvocation.getMethod(), (Object[])methodInvocation.getArguments()));
        NoticeableFuture future = IntrabandRPCUtil.execute((RegistrationReference)spi.getRegistrationReference(), (ProcessCallable)serviceMethodProcessCallable);
        Object result = future.get();
        Method method = methodInvocation.getMethod();
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE) {
            result = this.nullResult;
        }
        return result;
    }

    @Override
    public AccessControlled getNullAnnotation() {
        return AccessControl.NULL_ACCESS_CONTROLLED;
    }
}

