/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.statistics.service;

import com.liferay.portal.kernel.monitoring.DataSample;
import com.liferay.portal.kernel.monitoring.DataSampleThreadLocal;
import com.liferay.portal.kernel.monitoring.MethodSignature;
import com.liferay.portal.kernel.monitoring.RequestStatus;
import com.liferay.portal.kernel.monitoring.ServiceMonitoringControl;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.monitoring.statistics.DataSampleFactoryUtil;
import com.liferay.portal.spring.aop.ChainableMethodAdvice;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.aopalliance.intercept.MethodInvocation;

public class ServiceMonitorAdvice
extends ChainableMethodAdvice
implements ServiceMonitoringControl {
    private static final ThreadLocal<DataSample> _dataSampleThreadLocal = new AutoResetThreadLocal(ServiceMonitorAdvice.class + "._dataSampleThreadLocal");
    private static boolean _inclusiveMode = true;
    private static boolean _monitorServiceRequest;
    private static final Set<String> _serviceClasses;
    private static final Set<MethodSignature> _serviceClassMethods;

    public void addServiceClass(String className) {
        _serviceClasses.add(className);
    }

    public void addServiceClassMethod(String className, String methodName, String[] parameterTypes) {
        MethodSignature methodSignature = new MethodSignature(className, methodName, parameterTypes);
        _serviceClassMethods.add(methodSignature);
    }

    @Override
    public void afterReturning(MethodInvocation methodInvocation, Object result) throws Throwable {
        DataSample dataSample = _dataSampleThreadLocal.get();
        if (dataSample != null) {
            dataSample.capture(RequestStatus.SUCCESS);
        }
    }

    @Override
    public void afterThrowing(MethodInvocation methodInvocation, Throwable throwable) throws Throwable {
        DataSample dataSample = _dataSampleThreadLocal.get();
        if (dataSample != null) {
            dataSample.capture(RequestStatus.ERROR);
        }
    }

    @Override
    public Object before(MethodInvocation methodInvocation) throws Throwable {
        if (!_monitorServiceRequest) {
            this.serviceBeanAopCacheManager.removeMethodInterceptor(methodInvocation, this);
            return null;
        }
        boolean included = this.isIncluded(methodInvocation);
        if (!_inclusiveMode && included || _inclusiveMode && !included) {
            return null;
        }
        MethodSignature methodSignature = new MethodSignature(methodInvocation.getMethod());
        DataSample dataSample = DataSampleFactoryUtil.createServiceRequestDataSample(methodSignature);
        dataSample.prepare();
        _dataSampleThreadLocal.set(dataSample);
        DataSampleThreadLocal.initialize();
        return null;
    }

    @Override
    public void duringFinally(MethodInvocation methodInvocation) {
        DataSample dataSample = _dataSampleThreadLocal.get();
        if (dataSample != null) {
            _dataSampleThreadLocal.remove();
            DataSampleThreadLocal.addDataSample((DataSample)dataSample);
        }
    }

    public Set<String> getServiceClasses() {
        return Collections.unmodifiableSet(_serviceClasses);
    }

    public Set<MethodSignature> getServiceClassMethods() {
        return Collections.unmodifiableSet(_serviceClassMethods);
    }

    public boolean isInclusiveMode() {
        return _inclusiveMode;
    }

    public boolean isMonitorServiceRequest() {
        return _monitorServiceRequest;
    }

    public void setInclusiveMode(boolean inclusiveMode) {
        _inclusiveMode = inclusiveMode;
    }

    public void setMonitorServiceRequest(boolean monitorServiceRequest) {
        if (monitorServiceRequest && !_monitorServiceRequest) {
            this.serviceBeanAopCacheManager.reset();
        }
        _monitorServiceRequest = monitorServiceRequest;
    }

    protected boolean isIncluded(MethodInvocation methodInvocation) {
        Method method = methodInvocation.getMethod();
        Class<?> declaringClass = method.getDeclaringClass();
        String className = declaringClass.getName();
        if (_serviceClasses.contains(className)) {
            return true;
        }
        MethodSignature methodSignature = new MethodSignature(method);
        return _serviceClassMethods.contains(methodSignature);
    }

    static {
        _serviceClasses = new HashSet<String>();
        _serviceClassMethods = new HashSet<MethodSignature>();
    }
}

