/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.RoleConstants;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.service.TeamLocalServiceUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.RoleBaseImpl;

public class RoleImpl
extends RoleBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(RoleImpl.class);

    public String getDescriptiveName() throws PortalException {
        String name = this.getName();
        if (this.isTeam()) {
            Team team = TeamLocalServiceUtil.getTeam((long)this.getClassPK());
            name = team.getName();
        }
        return name;
    }

    @Override
    public String getTitle(String languageId) {
        String value = super.getTitle(languageId);
        if (Validator.isNull((String)value)) {
            try {
                value = this.getDescriptiveName();
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        return value;
    }

    @Override
    public String getTitle(String languageId, boolean useDefault) {
        String value = super.getTitle(languageId, useDefault);
        if (Validator.isNull((String)value)) {
            try {
                value = this.getDescriptiveName();
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        return value;
    }

    public String getTypeLabel() {
        return RoleConstants.getTypeLabel((int)this.getType());
    }

    public boolean isSystem() {
        return PortalUtil.isSystemRole((String)this.getName());
    }

    public boolean isTeam() {
        return this.hasClassName(Team.class);
    }

    protected boolean hasClassName(Class<?> clazz) {
        long classNameId = this.getClassNameId();
        return classNameId == PortalUtil.getClassNameId(clazz);
    }
}

