/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.service.AddressLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.PortalPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.AddressImpl;
import com.liferay.portal.model.impl.GroupImpl;
import com.liferay.portal.model.impl.OrganizationBaseImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.portlet.PortletPreferences;

public class OrganizationImpl
extends OrganizationBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(OrganizationImpl.class);

    public static String[] getChildrenTypes(String type) {
        return PropsUtil.getArray("organizations.children.types", new Filter(type));
    }

    public static String[] getParentTypes(String type) {
        String[] types = PropsUtil.getArray("organizations.types", new Filter(type));
        ArrayList<String> parentTypes = new ArrayList<String>();
        for (String curType : types) {
            if (!ArrayUtil.contains((Object[])OrganizationImpl.getChildrenTypes(curType), (Object)type)) continue;
            parentTypes.add(curType);
        }
        return parentTypes.toArray(new String[parentTypes.size()]);
    }

    public static boolean isParentable(String type) {
        String[] childrenTypes = OrganizationImpl.getChildrenTypes(type);
        return childrenTypes.length > 0;
    }

    public static boolean isRootable(String type) {
        return GetterUtil.getBoolean((String)PropsUtil.get("organizations.rootable", new Filter(type)));
    }

    public Address getAddress() {
        Address address = null;
        try {
            List<Address> addresses = this.getAddresses();
            if (!addresses.isEmpty()) {
                address = addresses.get(0);
            }
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
        if (address == null) {
            address = new AddressImpl();
        }
        return address;
    }

    public List<Address> getAddresses() {
        return AddressLocalServiceUtil.getAddresses((long)this.getCompanyId(), (String)Organization.class.getName(), (long)this.getOrganizationId());
    }

    public long[] getAncestorOrganizationIds() throws PortalException {
        if (Validator.isNull((String)this.getTreePath())) {
            List<Organization> ancestorOrganizations = this.getAncestors();
            long[] ancestorOrganizationIds = new long[ancestorOrganizations.size()];
            for (int i = 0; i < ancestorOrganizations.size(); ++i) {
                Organization organization = ancestorOrganizations.get(i);
                ancestorOrganizationIds[ancestorOrganizations.size() - i - 1] = organization.getOrganizationId();
            }
            return ancestorOrganizationIds;
        }
        long[] primaryKeys = StringUtil.split((String)this.getTreePath(), (String)"/", (long)0L);
        if (primaryKeys.length <= 2) {
            return new long[0];
        }
        long[] ancestorOrganizationIds = new long[primaryKeys.length - 2];
        System.arraycopy(primaryKeys, 1, ancestorOrganizationIds, 0, primaryKeys.length - 2);
        return ancestorOrganizationIds;
    }

    public List<Organization> getAncestors() throws PortalException {
        ArrayList<Organization> ancestors = new ArrayList<Organization>();
        OrganizationImpl organization = this;
        while (!organization.isRoot()) {
            organization = organization.getParentOrganization();
            ancestors.add(organization);
        }
        return ancestors;
    }

    public String[] getChildrenTypes() {
        return OrganizationImpl.getChildrenTypes(this.getType());
    }

    public List<Organization> getDescendants() {
        LinkedHashSet<Organization> descendants = new LinkedHashSet<Organization>();
        for (Organization suborganization : this.getSuborganizations()) {
            descendants.add(suborganization);
            descendants.addAll(suborganization.getDescendants());
        }
        return new ArrayList<Organization>(descendants);
    }

    public Group getGroup() {
        if (this.getOrganizationId() > 0L) {
            try {
                return GroupLocalServiceUtil.getOrganizationGroup((long)this.getCompanyId(), (long)this.getOrganizationId());
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        }
        return new GroupImpl();
    }

    public long getGroupId() {
        Group group = this.getGroup();
        return group.getGroupId();
    }

    public Organization getParentOrganization() throws PortalException {
        if (this.getParentOrganizationId() == 0L) {
            return null;
        }
        return OrganizationLocalServiceUtil.getOrganization((long)this.getParentOrganizationId());
    }

    public String getParentOrganizationName() {
        if (this.getParentOrganizationId() == 0L) {
            return "";
        }
        Organization parentOrganization = OrganizationLocalServiceUtil.fetchOrganization((long)this.getParentOrganizationId());
        if (parentOrganization != null) {
            return parentOrganization.getName();
        }
        return "";
    }

    public PortletPreferences getPreferences() {
        long ownerId = this.getOrganizationId();
        int ownerType = 6;
        return PortalPreferencesLocalServiceUtil.getPreferences((long)ownerId, (int)ownerType);
    }

    public int getPrivateLayoutsPageCount() {
        try {
            Group group = this.getGroup();
            if (group == null) {
                return 0;
            }
            return group.getPrivateLayoutsPageCount();
        }
        catch (Exception e) {
            _log.error((Throwable)e);
            return 0;
        }
    }

    public int getPublicLayoutsPageCount() {
        try {
            Group group = this.getGroup();
            if (group == null) {
                return 0;
            }
            return group.getPublicLayoutsPageCount();
        }
        catch (Exception e) {
            _log.error((Throwable)e);
            return 0;
        }
    }

    public Set<String> getReminderQueryQuestions(Locale locale) {
        return this.getReminderQueryQuestions(LanguageUtil.getLanguageId((Locale)locale));
    }

    public Set<String> getReminderQueryQuestions(String languageId) {
        PortletPreferences preferences = this.getPreferences();
        Object[] questions = StringUtil.splitLines((String)LocalizationUtil.getPreferencesValue((PortletPreferences)preferences, (String)"reminderQueries", (String)languageId, (boolean)false));
        return SetUtil.fromArray((Object[])questions);
    }

    public List<Organization> getSuborganizations() {
        return OrganizationLocalServiceUtil.getSuborganizations((long)this.getCompanyId(), (long)this.getOrganizationId());
    }

    public int getSuborganizationsSize() {
        return OrganizationLocalServiceUtil.getSuborganizationsCount((long)this.getCompanyId(), (long)this.getOrganizationId());
    }

    public int getTypeOrder() {
        String[] types = PropsValues.ORGANIZATIONS_TYPES;
        for (int i = 0; i < types.length; ++i) {
            String type = types[i];
            if (!type.equals(this.getType())) continue;
            return i + 1;
        }
        return 0;
    }

    public boolean hasPrivateLayouts() {
        return this.getPrivateLayoutsPageCount() > 0;
    }

    public boolean hasPublicLayouts() {
        return this.getPublicLayoutsPageCount() > 0;
    }

    public boolean hasSuborganizations() {
        return this.getSuborganizationsSize() > 0;
    }

    public boolean isParentable() {
        return OrganizationImpl.isParentable(this.getType());
    }

    public boolean isRoot() {
        return this.getParentOrganizationId() == 0L;
    }
}

