/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.minifier;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.minifier.GoogleJavaScriptMinifier;
import com.liferay.portal.minifier.JavaScriptMinifier;
import com.liferay.portal.util.PropsValues;
import com.yahoo.platform.yui.compressor.CssCompressor;
import java.io.Reader;
import java.io.Writer;

public class MinifierUtil {
    private static final Log _log = LogFactoryUtil.getLog(MinifierUtil.class);
    private static final MinifierUtil _instance = new MinifierUtil();
    private final JavaScriptMinifier _javaScriptMinifierInstance = MinifierUtil._getJavaScriptMinifier();

    public static String minifyCss(String content) {
        if (!PropsValues.MINIFIER_ENABLED) {
            return content;
        }
        return _instance._minifyCss(content);
    }

    public static String minifyJavaScript(String resourceName, String content) {
        if (!PropsValues.MINIFIER_ENABLED) {
            return content;
        }
        return _instance._minifyJavaScript(resourceName, content);
    }

    private static JavaScriptMinifier _getJavaScriptMinifier() {
        try {
            return (JavaScriptMinifier)InstanceFactory.newInstance((String)PropsValues.MINIFIER_JAVASCRIPT_IMPL);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to instantiate " + PropsValues.MINIFIER_JAVASCRIPT_IMPL));
            return new GoogleJavaScriptMinifier();
        }
    }

    private MinifierUtil() {
    }

    private String _minifyCss(String content) {
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        try {
            CssCompressor cssCompressor = new CssCompressor((Reader)new UnsyncStringReader(content));
            cssCompressor.compress((Writer)unsyncStringWriter, PropsValues.YUI_COMPRESSOR_CSS_LINE_BREAK);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to minfiy CSS:\n" + content));
            unsyncStringWriter.append((CharSequence)content);
        }
        return unsyncStringWriter.toString();
    }

    private String _minifyJavaScript(String resourceName, String content) {
        return this._javaScriptMinifierInstance.compress(resourceName, content);
    }
}

