/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.metadata;

import com.liferay.document.library.kernel.util.AudioProcessorUtil;
import com.liferay.document.library.kernel.util.VideoProcessorUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xuggler.XugglerUtil;
import com.liferay.portal.metadata.BaseRawMetadataProcessor;
import com.xuggle.xuggler.IContainer;
import java.io.File;
import java.io.InputStream;
import java.text.DecimalFormat;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.XMPDM;

public class XugglerRawMetadataProcessor
extends BaseRawMetadataProcessor {
    private static final Log _log = LogFactoryUtil.getLog(XugglerRawMetadataProcessor.class);
    private static final DecimalFormat _decimalFormatter = new DecimalFormat("00");

    public void exportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) {
    }

    public void importGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) {
    }

    protected String convertTime(long microseconds) {
        long milliseconds = microseconds / 1000L;
        StringBundler sb = new StringBundler(7);
        sb.append(_decimalFormatter.format(milliseconds / 3600000L));
        sb.append(":");
        sb.append(_decimalFormatter.format(milliseconds % 3600000L / 60000L));
        sb.append(":");
        sb.append(_decimalFormatter.format(milliseconds % 60000L / 1000L));
        sb.append(".");
        sb.append(_decimalFormatter.format(milliseconds % 1000L / 10L));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Metadata extractMetadata(File file) throws Exception {
        IContainer container = IContainer.make();
        try {
            Metadata metadata = new Metadata();
            if (container.open(file.getCanonicalPath(), IContainer.Type.READ, null) < 0) {
                throw new IllegalArgumentException("Could not open stream");
            }
            if (container.queryStreamMetaData() < 0) {
                throw new IllegalStateException("Could not query stream metadata");
            }
            long microseconds = container.getDuration();
            metadata.set(XMPDM.DURATION, this.convertTime(microseconds));
            Metadata metadata2 = metadata;
            return metadata2;
        }
        finally {
            if (container.isOpened()) {
                container.close();
            }
        }
    }

    @Override
    protected Metadata extractMetadata(String extension, String mimeType, File file) {
        Metadata metadata = null;
        if (!this.isSupported(mimeType)) {
            return metadata;
        }
        try {
            metadata = this.extractMetadata(file);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Metadata extractMetadata(String extension, String mimeType, InputStream inputStream) {
        Metadata metadata = null;
        File file = null;
        if (!this.isSupported(mimeType)) {
            return metadata;
        }
        try {
            file = FileUtil.createTempFile((String)extension);
            FileUtil.write((File)file, (InputStream)inputStream);
            metadata = this.extractMetadata(file);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        finally {
            FileUtil.delete((File)file);
        }
        return metadata;
    }

    protected boolean isSupported(String mimeType) {
        if (XugglerUtil.isEnabled()) {
            if (AudioProcessorUtil.isAudioSupported((String)mimeType)) {
                return true;
            }
            if (VideoProcessorUtil.isVideoSupported((String)mimeType)) {
                return true;
            }
        }
        return false;
    }
}

