/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.portal.action.JSONServiceAction;
import com.liferay.portal.jsonwebservice.action.JSONWebServiceDiscoverAction;
import com.liferay.portal.jsonwebservice.action.JSONWebServiceInvokerAction;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceAction;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionsManagerUtil;
import com.liferay.portal.kernel.jsonwebservice.NoSuchJSONWebServiceException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class JSONWebServiceServiceAction
extends JSONServiceAction {
    private static final String _REROUTE_PATH = "/jsonws";
    private static final Log _log = LogFactoryUtil.getLog(JSONWebServiceServiceAction.class);

    @Override
    public String getJSON(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        UploadException uploadException = (UploadException)request.getAttribute("UPLOAD_EXCEPTION");
        if (uploadException != null) {
            return JSONFactoryUtil.serializeThrowable((Throwable)uploadException);
        }
        try {
            JSONWebServiceAction jsonWebServiceAction = this.getJSONWebServiceAction(request);
            Object returnObj = jsonWebServiceAction.invoke();
            if (returnObj != null) {
                return this.getReturnValue(returnObj);
            }
            return JSONFactoryUtil.getNullJSON();
        }
        catch (Exception e) {
            int status = 0;
            if (e instanceof InvocationTargetException) {
                Throwable throwable = e.getCause();
                status = throwable instanceof PrincipalException || throwable instanceof SecurityException ? 403 : 500;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)this.getThrowableMessage(throwable), throwable);
                } else {
                    _log.error((Object)this.getThrowableMessage(throwable));
                }
                response.setStatus(status);
                return JSONFactoryUtil.serializeThrowable((Throwable)throwable);
            }
            status = e instanceof NoSuchJSONWebServiceException ? 404 : (e instanceof PrincipalException || e instanceof SecurityException ? 403 : 500);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)this.getThrowableMessage(e), (Throwable)e);
            } else {
                _log.error((Object)this.getThrowableMessage(e));
            }
            response.setStatus(status);
            return JSONFactoryUtil.serializeThrowable((Throwable)e);
        }
    }

    @Override
    protected String getCSRFOrigin(HttpServletRequest request) {
        String uri = request.getRequestURI();
        int x = uri.indexOf("jsonws/");
        if (x < 0) {
            return ClassUtil.getClassName((Object)((Object)this));
        }
        String path = uri.substring(x + 7);
        String[] pathArray = StringUtil.split((String)path, (char)'/');
        if (pathArray.length < 2) {
            return ClassUtil.getClassName((Object)((Object)this));
        }
        StringBundler sb = new StringBundler(6);
        sb.append(ClassUtil.getClassName((Object)((Object)this)));
        sb.append(":");
        sb.append("/");
        String serviceClassName = pathArray[0];
        sb.append(serviceClassName);
        sb.append("/");
        String serviceMethodName = pathArray[1];
        sb.append(serviceMethodName);
        return sb.toString();
    }

    protected JSONWebServiceAction getJSONWebServiceAction(HttpServletRequest request) throws NoSuchJSONWebServiceException {
        String path = GetterUtil.getString((String)request.getPathInfo());
        if (path.equals("/invoke")) {
            return new JSONWebServiceInvokerAction(request);
        }
        if (PropsValues.JSONWS_WEB_SERVICE_API_DISCOVERABLE && request.getParameter("discover") != null) {
            return new JSONWebServiceDiscoverAction(request);
        }
        return JSONWebServiceActionsManagerUtil.getJSONWebServiceAction((HttpServletRequest)request);
    }

    @Override
    protected String getReroutePath() {
        return _REROUTE_PATH;
    }

    protected String getThrowableMessage(Throwable throwable) {
        String message = throwable.getMessage();
        if (Validator.isNotNull((String)message)) {
            return message;
        }
        return throwable.toString();
    }
}

