/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.agent;

import com.liferay.portal.fabric.agent.FabricAgent;
import com.liferay.portal.fabric.agent.FabricAgentListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class FabricAgentRegistry {
    private final FabricAgent _defaultFabricAgent;
    private final CopyOnWriteArrayList<FabricAgentListener> _fabricAgentListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<FabricAgent> _fabricAgents = new CopyOnWriteArrayList();

    public FabricAgentRegistry(FabricAgent defaultFabricAgent) {
        if (defaultFabricAgent == null) {
            throw new NullPointerException("Default fabric agent is null");
        }
        this._defaultFabricAgent = defaultFabricAgent;
    }

    public FabricAgent getDefaultFabricAgent() {
        return this._defaultFabricAgent;
    }

    public List<FabricAgentListener> getFabricAgentListeners() {
        return new ArrayList<FabricAgentListener>(this._fabricAgentListeners);
    }

    public List<FabricAgent> getFabricAgents() {
        return new ArrayList<FabricAgent>(this._fabricAgents);
    }

    public boolean registerFabricAgent(FabricAgent fabricAgent, Runnable runnable) {
        if (this._fabricAgents.addIfAbsent(fabricAgent)) {
            if (runnable != null) {
                runnable.run();
            }
            for (FabricAgentListener fabricAgentListener : this._fabricAgentListeners) {
                fabricAgentListener.registered(fabricAgent);
            }
            return true;
        }
        return false;
    }

    public boolean registerFabricAgentListener(FabricAgentListener fabricAgentListener) {
        return this._fabricAgentListeners.addIfAbsent(fabricAgentListener);
    }

    public boolean unregisterFabricAgent(FabricAgent fabricAgent, Runnable runnable) {
        if (this._fabricAgents.remove(fabricAgent)) {
            if (runnable != null) {
                runnable.run();
            }
            for (FabricAgentListener fabricAgentListener : this._fabricAgentListeners) {
                fabricAgentListener.unregistered(fabricAgent);
            }
            return true;
        }
        return false;
    }

    public boolean unregisterFabricAgentListener(FabricAgentListener fabricAgentListener) {
        return this._fabricAgentListeners.remove(fabricAgentListener);
    }
}

