/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.security.RandomUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RandomLayoutAction
extends Action {
    private static final Log _log = LogFactoryUtil.getLog(RandomLayoutAction.class);

    public void run(HttpServletRequest request, HttpServletResponse response) throws ActionException {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            if (!themeDisplay.isSignedIn()) {
                return;
            }
            String requestURI = GetterUtil.getString((String)request.getRequestURI());
            if (!requestURI.endsWith("/portal/layout")) {
                return;
            }
            Layout layout = themeDisplay.getLayout();
            if (layout == null) {
                return;
            }
            Group generalGuestGroup = GroupLocalServiceUtil.getGroup((long)themeDisplay.getCompanyId(), (String)"Guest");
            List layouts = LayoutLocalServiceUtil.getLayouts((long)generalGuestGroup.getGroupId(), (boolean)false);
            if (!layouts.isEmpty()) {
                Layout randomLayout = (Layout)layouts.get(RandomUtil.nextInt((int)layouts.size()));
                themeDisplay.setLayout(randomLayout);
                themeDisplay.setLayoutTypePortlet((LayoutTypePortlet)randomLayout.getLayoutType());
                request.setAttribute("LAYOUT", (Object)randomLayout);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new ActionException((Throwable)e);
        }
    }
}

