/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.jdbc.pool.metrics;

import com.liferay.portal.dao.jdbc.aop.DefaultDynamicDataSourceTargetSource;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.dao.jdbc.pool.metrics.ConnectionPoolMetrics;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import javax.sql.DataSource;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.jdbc.datasource.LazyConnectionDataSourceProxy;

public abstract class BaseConnectionPoolMetrics
implements ConnectionPoolMetrics {
    private static final Log _log = LogFactoryUtil.getLog(BaseConnectionPoolMetrics.class);
    private String _name;

    public String getConnectionPoolName() {
        if (this._name == null) {
            this.initializeConnectionPool();
        }
        return this._name;
    }

    protected abstract Object getDataSource();

    protected abstract String getPoolName();

    protected void initializeConnectionPool() {
        block8: {
            Advised advised;
            LazyConnectionDataSourceProxy lazyConnectionDataSourceProxy = (LazyConnectionDataSourceProxy)PortalBeanLocatorUtil.locate((String)"counterDataSource");
            Object dataSource = this.getDataSource();
            if (dataSource == null) {
                return;
            }
            if (dataSource.equals(lazyConnectionDataSourceProxy.getTargetDataSource())) {
                this._name = "counterDataSource";
                return;
            }
            lazyConnectionDataSourceProxy = (LazyConnectionDataSourceProxy)PortalBeanLocatorUtil.locate((String)"liferayDataSource");
            DataSource targetDataSource = lazyConnectionDataSourceProxy.getTargetDataSource();
            if (dataSource.equals(targetDataSource)) {
                this._name = "liferayDataSource";
                return;
            }
            if (AopUtils.isAopProxy((Object)targetDataSource) && targetDataSource instanceof Advised && (targetDataSource = (advised = (Advised)targetDataSource).getTargetSource()) instanceof DefaultDynamicDataSourceTargetSource) {
                try {
                    DataSource readDataSource = ((DefaultDynamicDataSourceTargetSource)((Object)targetDataSource)).getReadDataSource();
                    if (dataSource.equals(readDataSource)) {
                        this._name = "readDataSource";
                        return;
                    }
                    DataSource writeDataSource = ((DefaultDynamicDataSourceTargetSource)((Object)targetDataSource)).getWriteDataSource();
                    if (dataSource.equals(writeDataSource)) {
                        this._name = "writeDataSource";
                        return;
                    }
                }
                catch (Exception e) {
                    if (!_log.isDebugEnabled()) break block8;
                    _log.debug((Object)e.getMessage());
                }
            }
        }
        this._name = this.getPoolName();
    }
}

