/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ratings.kernel.display.context;

import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.ratings.kernel.RatingsType;
import com.liferay.ratings.kernel.definition.PortletRatingsDefinitionUtil;
import com.liferay.ratings.kernel.definition.PortletRatingsDefinitionValues;
import com.liferay.ratings.kernel.transformer.RatingsDataTransformerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class GroupPortletRatingsDefinitionDisplayContext {
    private final Map<String, Map<String, RatingsType>> _groupRatingsTypeMaps = new HashMap<String, Map<String, RatingsType>>();

    public GroupPortletRatingsDefinitionDisplayContext(UnicodeProperties groupTypeSettings, HttpServletRequest request) {
        this._populateRatingsTypeMaps(groupTypeSettings, request);
    }

    public Map<String, Map<String, RatingsType>> getGroupRatingsTypeMaps() {
        return Collections.unmodifiableMap(this._groupRatingsTypeMaps);
    }

    private void _populateRatingsTypeMaps(UnicodeProperties groupTypeSettings, HttpServletRequest request) {
        Map<String, PortletRatingsDefinitionValues> portletRatingsDefinitionValuesMap = PortletRatingsDefinitionUtil.getPortletRatingsDefinitionValuesMap();
        for (String className : portletRatingsDefinitionValuesMap.keySet()) {
            PortletRatingsDefinitionValues portletRatingsDefinitionValues = portletRatingsDefinitionValuesMap.get(className);
            if (portletRatingsDefinitionValues == null) continue;
            String portletId = portletRatingsDefinitionValues.getPortletId();
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            if (!PortletLocalServiceUtil.hasPortlet(themeDisplay.getCompanyId(), portletId)) continue;
            HashMap<String, RatingsType> ratingsTypeMap = new HashMap<String, RatingsType>();
            String propertyKey = RatingsDataTransformerUtil.getPropertyKey(className);
            String groupRatingsTypeString = PropertiesParamUtil.getString(groupTypeSettings, request, propertyKey);
            RatingsType ratingsType = null;
            if (Validator.isNotNull(groupRatingsTypeString)) {
                ratingsType = RatingsType.parse(groupRatingsTypeString);
            }
            ratingsTypeMap.put(className, ratingsType);
            this._groupRatingsTypeMaps.put(portletId, ratingsTypeMap);
        }
    }
}

