/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.kernel.util.TimeZoneThreadLocal;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public class TimeZoneUtil {
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static volatile TimeZone _timeZone = TimeZone.getTimeZone("UTC");
    private static final Map<String, TimeZone> _timeZones = new ConcurrentHashMap<String, TimeZone>();

    public static TimeZone getDefault() {
        TimeZone timeZone = TimeZoneThreadLocal.getDefaultTimeZone();
        if (timeZone != null) {
            return timeZone;
        }
        return _timeZone;
    }

    public static TimeZoneUtil getInstance() {
        PortalRuntimePermission.checkGetBeanProperty(TimeZoneUtil.class);
        return new TimeZoneUtil();
    }

    public static TimeZone getTimeZone(String timeZoneId) {
        TimeZone timeZone = _timeZones.get(timeZoneId);
        if (timeZone == null) {
            timeZone = TimeZone.getTimeZone(timeZoneId);
            _timeZones.put(timeZoneId, timeZone);
        }
        return timeZone;
    }

    public static void setDefault(String timeZoneId) {
        PortalRuntimePermission.checkSetBeanProperty(TimeZoneUtil.class);
        if (Validator.isNotNull(timeZoneId)) {
            _timeZone = TimeZone.getTimeZone(timeZoneId);
        }
    }

    private TimeZoneUtil() {
    }
}

