/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Date;
import java.util.Map;

public class ThreadUtil {
    public static Thread[] getThreads() {
        Thread currentThread = Thread.currentThread();
        ThreadGroup threadGroup = currentThread.getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        int threadCountGuess = threadGroup.activeCount();
        Thread[] threads = new Thread[threadCountGuess];
        int threadCountActual = threadGroup.enumerate(threads);
        while (threadCountActual == threadCountGuess) {
            threads = new Thread[threadCountGuess *= 2];
            threadCountActual = threadGroup.enumerate(threads);
        }
        return threads;
    }

    public static String threadDump() {
        String threadDump = ThreadUtil._getThreadDumpFromJstack();
        if (Validator.isNull(threadDump)) {
            threadDump = ThreadUtil._getThreadDumpFromStackTrace();
        }
        return "\n\n".concat(threadDump);
    }

    private static String _getThreadDumpFromJstack() {
        UnsyncByteArrayOutputStream outputStream = new UnsyncByteArrayOutputStream();
        try {
            String vendorURL = System.getProperty("java.vendor.url");
            if (!vendorURL.equals("http://java.oracle.com/") && !vendorURL.equals("http://java.sun.com/")) {
                return "";
            }
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            String name = runtimeMXBean.getName();
            if (Validator.isNull(name)) {
                return "";
            }
            int pos = name.indexOf(64);
            if (pos == -1) {
                return "";
            }
            String pidString = name.substring(0, pos);
            if (!Validator.isNumber(pidString)) {
                return "";
            }
            Runtime runtime = Runtime.getRuntime();
            int pid = GetterUtil.getInteger(pidString);
            String[] cmd = new String[]{"jstack", String.valueOf(pid)};
            Process process = runtime.exec(cmd);
            InputStream inputStream = process.getInputStream();
            StreamUtil.transfer(inputStream, outputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return outputStream.toString();
    }

    private static String _getThreadDumpFromStackTrace() {
        String jvm = System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version");
        StringBundler sb = new StringBundler("Full thread dump of " + jvm + " on " + String.valueOf(new Date()) + "\n\n");
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : stackTraces.entrySet()) {
            Thread thread = entry.getKey();
            StackTraceElement[] elements = entry.getValue();
            sb.append("\"");
            sb.append(thread.getName());
            sb.append("\"");
            if (thread.getThreadGroup() != null) {
                sb.append(" ");
                sb.append("(");
                sb.append(thread.getThreadGroup().getName());
                sb.append(")");
            }
            sb.append(", priority=");
            sb.append(thread.getPriority());
            sb.append(", id=");
            sb.append(thread.getId());
            sb.append(", state=");
            sb.append((Object)thread.getState());
            sb.append("\n");
            for (int i = 0; i < elements.length; ++i) {
                sb.append("\t");
                sb.append(elements[i]);
                sb.append("\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

