/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.template;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateManager;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TemplateManagerUtil {
    private static final Log _log = LogFactoryUtil.getLog(TemplateManagerUtil.class);
    private static final TemplateManagerUtil _instance = new TemplateManagerUtil();
    private final ServiceTracker<TemplateManager, TemplateManager> _serviceTracker;
    private final Map<String, Set<String>> _supportedLanguageTypes = new ConcurrentHashMap<String, Set<String>>();
    private final Map<ServiceReference<TemplateManager>, TemplateManager> _templateManagers = new ConcurrentHashMap<ServiceReference<TemplateManager>, TemplateManager>();

    public static void destroy() {
        _instance._destroy();
    }

    public static void destroy(ClassLoader classLoader) {
        _instance._destroy(classLoader);
    }

    public static Set<String> getSupportedLanguageTypes(String propertyKey) {
        return _instance._getSupportedLanguageTypes(propertyKey);
    }

    public static Template getTemplate(String templateManagerName, List<TemplateResource> templateResources, boolean restricted) throws TemplateException {
        return _instance._getTemplate(templateManagerName, templateResources, restricted);
    }

    public static Template getTemplate(String templateManagerName, List<TemplateResource> templateResources, TemplateResource errorTemplateResource, boolean restricted) throws TemplateException {
        return _instance._getTemplate(templateManagerName, templateResources, errorTemplateResource, restricted);
    }

    public static Template getTemplate(String templateManagerName, TemplateResource templateResource, boolean restricted) throws TemplateException {
        return _instance._getTemplate(templateManagerName, templateResource, restricted);
    }

    public static Template getTemplate(String templateManagerName, TemplateResource templateResource, TemplateResource errorTemplateResource, boolean restricted) throws TemplateException {
        return _instance._getTemplate(templateManagerName, templateResource, errorTemplateResource, restricted);
    }

    public static TemplateManager getTemplateManager(String templateManagerName) {
        return _instance._getTemplateManager(templateManagerName);
    }

    public static Set<String> getTemplateManagerNames() {
        return _instance._getTemplateManagerNames();
    }

    public static Map<String, TemplateManager> getTemplateManagers() {
        return _instance._getTemplateManagers();
    }

    public static boolean hasTemplateManager(String templateManagerName) {
        return _instance._hasTemplateManager(templateManagerName);
    }

    private TemplateManagerUtil() {
        Registry registry = RegistryUtil.getRegistry();
        com.liferay.registry.Filter filter = registry.getFilter("(&(language.type=*)(objectClass=" + TemplateManager.class.getName() + "))");
        this._serviceTracker = registry.trackServices(filter, (ServiceTrackerCustomizer)new TemplateManagerServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    private void _destroy() {
        Map<String, TemplateManager> templateManagers = this._getTemplateManagers();
        for (TemplateManager templateManager : templateManagers.values()) {
            templateManager.destroy();
        }
        templateManagers.clear();
    }

    private void _destroy(ClassLoader classLoader) {
        Map<String, TemplateManager> templateManagers = this._getTemplateManagers();
        for (TemplateManager templateManager : templateManagers.values()) {
            templateManager.destroy(classLoader);
        }
    }

    private Set<String> _getSupportedLanguageTypes(String propertyKey) {
        Set<String> supportedLanguageTypes = this._supportedLanguageTypes.get(propertyKey);
        if (supportedLanguageTypes != null) {
            return supportedLanguageTypes;
        }
        Map<String, TemplateManager> templateManagers = this._getTemplateManagers();
        supportedLanguageTypes = new HashSet<String>();
        for (String templateManagerName : templateManagers.keySet()) {
            String content = PropsUtil.get(propertyKey, new Filter(templateManagerName));
            if (!Validator.isNotNull(content)) continue;
            supportedLanguageTypes.add(templateManagerName);
        }
        supportedLanguageTypes = Collections.unmodifiableSet(supportedLanguageTypes);
        this._supportedLanguageTypes.put(propertyKey, supportedLanguageTypes);
        return supportedLanguageTypes;
    }

    private Template _getTemplate(String templateManagerName, List<TemplateResource> templateResources, boolean restricted) throws TemplateException {
        TemplateManager templateManager = this._getTemplateManagerChecked(templateManagerName);
        return templateManager.getTemplate(templateResources, restricted);
    }

    private Template _getTemplate(String templateManagerName, List<TemplateResource> templateResources, TemplateResource errorTemplateResource, boolean restricted) throws TemplateException {
        TemplateManager templateManager = this._getTemplateManagerChecked(templateManagerName);
        return templateManager.getTemplate(templateResources, errorTemplateResource, restricted);
    }

    private Template _getTemplate(String templateManagerName, TemplateResource templateResource, boolean restricted) throws TemplateException {
        TemplateManager templateManager = this._getTemplateManagerChecked(templateManagerName);
        return templateManager.getTemplate(templateResource, restricted);
    }

    private Template _getTemplate(String templateManagerName, TemplateResource templateResource, TemplateResource errorTemplateResource, boolean restricted) throws TemplateException {
        TemplateManager templateManager = this._getTemplateManagerChecked(templateManagerName);
        return templateManager.getTemplate(templateResource, errorTemplateResource, restricted);
    }

    private TemplateManager _getTemplateManager(String templateManagerName) {
        Collection<TemplateManager> templateManagers = this._templateManagers.values();
        for (TemplateManager templateManager : templateManagers) {
            if (!templateManagerName.equals(templateManager.getName())) continue;
            return templateManager;
        }
        return null;
    }

    private TemplateManager _getTemplateManagerChecked(String templateManagerName) throws TemplateException {
        Collection<TemplateManager> templateManagers = this._templateManagers.values();
        for (TemplateManager templateManager : templateManagers) {
            if (!templateManagerName.equals(templateManager.getName())) continue;
            return templateManager;
        }
        throw new TemplateException("Unsupported template manager " + templateManagerName);
    }

    private Set<String> _getTemplateManagerNames() {
        Map<String, TemplateManager> templateManagers = this._getTemplateManagers();
        return templateManagers.keySet();
    }

    private Map<String, TemplateManager> _getTemplateManagers() {
        HashMap<String, TemplateManager> map = new HashMap<String, TemplateManager>();
        Collection<TemplateManager> templateManagers = this._templateManagers.values();
        for (TemplateManager templateManager : templateManagers) {
            map.put(templateManager.getName(), templateManager);
        }
        return Collections.unmodifiableMap(map);
    }

    private boolean _hasTemplateManager(String templateManagerName) {
        Collection<TemplateManager> templateManagers = this._templateManagers.values();
        for (TemplateManager templateManager : templateManagers) {
            if (!templateManagerName.equals(templateManager.getName())) continue;
            return true;
        }
        return false;
    }

    private class TemplateManagerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<TemplateManager, TemplateManager> {
        private TemplateManagerServiceTrackerCustomizer() {
        }

        public TemplateManager addingService(ServiceReference<TemplateManager> serviceReference) {
            TemplateManager templateManager;
            block2: {
                Registry registry = RegistryUtil.getRegistry();
                templateManager = (TemplateManager)registry.getService(serviceReference);
                String name = templateManager.getName();
                try {
                    templateManager.init();
                    TemplateManagerUtil.this._templateManagers.put(serviceReference, templateManager);
                }
                catch (TemplateException te) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn("unable to init " + name + " Template Manager ", te);
                }
            }
            return templateManager;
        }

        public void modifiedService(ServiceReference<TemplateManager> serviceReference, TemplateManager templateManager) {
        }

        public void removedService(ServiceReference<TemplateManager> serviceReference, TemplateManager templateManager) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            TemplateManagerUtil.this._templateManagers.remove(serviceReference);
            templateManager.destroy();
        }
    }
}

