/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet.taglib.aui;

import com.liferay.portal.kernel.util.Mergeable;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ScriptData
implements Mergeable<ScriptData>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ConcurrentMap<String, PortletData> _portletDataMap = new ConcurrentHashMap<String, PortletData>();
    private final List<ObjectValuePair<StringBundler, Integer>> _sbIndexList = new ArrayList<ObjectValuePair<StringBundler, Integer>>();

    public void append(String portletId, String content, String modules, ModulesType modulesType) {
        PortletData portletData = this._getPortletData(portletId);
        portletData.append(content, modules, modulesType);
    }

    public void append(String portletId, StringBundler contentSB, String modules, ModulesType modulesType) {
        PortletData portletData = this._getPortletData(portletId);
        portletData.append(contentSB, modules, modulesType);
    }

    public void mark() {
        for (PortletData portletData : this._portletDataMap.values()) {
            this._addToSBIndexList(portletData._auiCallbackSB);
            this._addToSBIndexList(portletData._es6CallbackSB);
            this._addToSBIndexList(portletData._rawSB);
        }
    }

    @Override
    public ScriptData merge(ScriptData scriptData) {
        if (scriptData != null && scriptData != this) {
            this._portletDataMap.putAll(scriptData._portletDataMap);
        }
        return this;
    }

    public void reset() {
        for (ObjectValuePair<StringBundler, Integer> ovp : this._sbIndexList) {
            StringBundler sb = ovp.getKey();
            sb.setIndex(ovp.getValue());
        }
    }

    @Override
    public ScriptData split() {
        return new ScriptData();
    }

    public void writeTo(Writer writer) throws IOException {
        writer.write("<script type=\"text/javascript\">\n// <![CDATA[\n");
        StringBundler auiModulesSB = new StringBundler(this._portletDataMap.size());
        HashSet auiModulesSet = new HashSet();
        StringBundler es6ModulesSB = new StringBundler(this._portletDataMap.size());
        HashSet es6ModulesSet = new HashSet();
        for (PortletData portletData : this._portletDataMap.values()) {
            portletData._rawSB.writeTo(writer);
            if (!portletData._auiModulesSet.isEmpty()) {
                auiModulesSB.append(portletData._auiCallbackSB);
            }
            if (!portletData._es6ModulesSet.isEmpty()) {
                es6ModulesSB.append(portletData._es6CallbackSB);
            }
            auiModulesSet.addAll(portletData._auiModulesSet);
            es6ModulesSet.addAll(portletData._es6ModulesSet);
        }
        if (auiModulesSB.index() == 0 && es6ModulesSB.index() == 0) {
            writer.write("\n// ]]>\n</script>");
            return;
        }
        if (!es6ModulesSet.isEmpty()) {
            writer.write("require(");
            Iterator iterator = es6ModulesSet.iterator();
            while (iterator.hasNext()) {
                writer.write("'");
                writer.write((String)iterator.next());
                writer.write("'");
                if (!iterator.hasNext()) continue;
                writer.write(", ");
            }
            writer.write(", ");
            writer.write("function(");
            iterator = es6ModulesSet.iterator();
            HashSet<String> variableNames = new HashSet<String>(es6ModulesSet.size());
            while (iterator.hasNext()) {
                writer.write(this._generateVariable((String)iterator.next(), variableNames));
                if (!iterator.hasNext()) continue;
                writer.write(", ");
            }
            writer.write(") {\n");
            es6ModulesSB.writeTo(writer);
            writer.write("},\nfunction(error) {\nconsole.error(error);\n});");
        }
        if (!auiModulesSet.isEmpty()) {
            writer.write("AUI().use(");
            for (String use : auiModulesSet) {
                writer.write("'");
                writer.write(use);
                writer.write("'");
                writer.write(", ");
            }
            writer.write("function(A) {");
            auiModulesSB.writeTo(writer);
            writer.write("});");
        }
        writer.write("\n// ]]>\n</script>");
    }

    private void _addToSBIndexList(StringBundler sb) {
        ObjectValuePair<StringBundler, Integer> ovp = new ObjectValuePair<StringBundler, Integer>(sb, sb.index());
        int index = this._sbIndexList.indexOf(ovp);
        if (index == -1) {
            this._sbIndexList.add(ovp);
        } else {
            ovp = this._sbIndexList.get(index);
            ovp.setValue(sb.index());
        }
    }

    private String _generateVariable(String name, Set<String> names) {
        StringBuilder sb = new StringBuilder(name.length());
        char c = name.charAt(0);
        boolean modified = false;
        if ('a' <= c && c <= 'z') {
            sb.append((char)(c - 32));
            modified = true;
        } else if ('A' <= c && c <= 'Z' || c == '_') {
            sb.append(c);
        } else {
            sb.append('_');
            modified = true;
        }
        for (int i = 1; i < name.length(); ++i) {
            c = name.charAt(i);
            if ('a' <= c && c <= 'z') {
                sb.append((char)(c - 32));
                modified = true;
                continue;
            }
            if (!('A' <= c && c <= 'Z' || '0' <= c && c <= '9') && c != '_') continue;
            sb.append(c);
        }
        String safeName = name;
        if (modified) {
            name = safeName = sb.toString();
        }
        int i = 1;
        while (!names.add(name)) {
            name = safeName.concat(String.valueOf(i++));
        }
        return name;
    }

    private PortletData _getPortletData(String portletId) {
        PortletData oldPortletData;
        PortletData portletData;
        if (Validator.isNull(portletId)) {
            portletId = "";
        }
        if ((portletData = (PortletData)this._portletDataMap.get(portletId)) == null && (oldPortletData = this._portletDataMap.putIfAbsent(portletId, portletData = new PortletData())) != null) {
            portletData = oldPortletData;
        }
        return portletData;
    }

    private static class PortletData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final StringBundler _auiCallbackSB = new StringBundler();
        private final Set<String> _auiModulesSet = new HashSet<String>();
        private final StringBundler _es6CallbackSB = new StringBundler();
        private final Set<String> _es6ModulesSet = new HashSet<String>();
        private final StringBundler _rawSB = new StringBundler();

        private PortletData() {
        }

        public void append(String content, String modules, ModulesType modulesType) {
            if (Validator.isNull(modules)) {
                this._rawSB.append(content);
            } else {
                String[] modulesArray = StringUtil.split(modules);
                if (modulesType == ModulesType.AUI) {
                    this._auiCallbackSB.append("(function() {");
                    this._auiCallbackSB.append(content);
                    this._auiCallbackSB.append("})();");
                    for (String module : modulesArray) {
                        this._auiModulesSet.add(StringUtil.trim(module));
                    }
                } else {
                    this._es6CallbackSB.append("(function() {");
                    this._es6CallbackSB.append(content);
                    this._es6CallbackSB.append("})();");
                    for (String module : modulesArray) {
                        this._es6ModulesSet.add(StringUtil.trim(module));
                    }
                }
            }
        }

        public void append(StringBundler contentSB, String modules, ModulesType modulesType) {
            if (Validator.isNull(modules)) {
                this._rawSB.append(contentSB);
            } else {
                String[] modulesArray = StringUtil.split(modules);
                if (modulesType == ModulesType.AUI) {
                    this._auiCallbackSB.append("(function() {");
                    this._auiCallbackSB.append(contentSB);
                    this._auiCallbackSB.append("})();");
                    for (String module : modulesArray) {
                        this._auiModulesSet.add(StringUtil.trim(module));
                    }
                } else {
                    this._es6CallbackSB.append("(function() {");
                    this._es6CallbackSB.append(contentSB);
                    this._es6CallbackSB.append("})();");
                    for (String module : modulesArray) {
                        this._es6ModulesSet.add(StringUtil.trim(module));
                    }
                }
            }
        }
    }

    public static enum ModulesType {
        AUI,
        ES6;

    }
}

