/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.servlet.ProtectedPrincipal;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ProtectedServletRequest
extends HttpServletRequestWrapper {
    private String _authType;
    private final String _remoteUser;
    private final Principal _userPrincipal;

    public ProtectedServletRequest(HttpServletRequest request, String remoteUser) {
        this(request, remoteUser, null);
    }

    public ProtectedServletRequest(HttpServletRequest request, String remoteUser, String authType) {
        super(request);
        if (request instanceof ProtectedServletRequest) {
            ProtectedServletRequest parentRequest = (ProtectedServletRequest)request;
            this.setRequest(parentRequest.getRequest());
        }
        this._remoteUser = remoteUser;
        this._userPrincipal = remoteUser != null ? new ProtectedPrincipal(remoteUser) : null;
        this._authType = authType;
    }

    public String getAuthType() {
        if (this._authType == null) {
            return super.getAuthType();
        }
        if (this._authType.equals("BASIC")) {
            return "BASIC";
        }
        if (this._authType.equals("CLIENT_CERT")) {
            return "CLIENT_CERT";
        }
        if (this._authType.equals("DIGEST")) {
            return "DIGEST";
        }
        if (this._authType.equals("FORM")) {
            return "FORM";
        }
        return this._authType;
    }

    public String getRemoteUser() {
        if (this._remoteUser != null) {
            return this._remoteUser;
        }
        return super.getRemoteUser();
    }

    public Principal getUserPrincipal() {
        if (this._userPrincipal != null) {
            return this._userPrincipal;
        }
        return super.getUserPrincipal();
    }
}

