/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.util.Validator;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;

public class PortalSessionContext {
    private static final PortalSessionContext _instance = new PortalSessionContext();
    private final Map<String, HttpSession> _sessionPool = new ConcurrentHashMap<String, HttpSession>();

    public static int count() {
        return _instance._count();
    }

    public static HttpSession get(String sessionId) {
        return _instance._get(sessionId);
    }

    public static void put(String sessionId, HttpSession session) {
        _instance._put(sessionId, session);
    }

    public static HttpSession remove(String sessionId) {
        return _instance._remove(sessionId);
    }

    public static Collection<HttpSession> values() {
        return _instance._values();
    }

    protected PortalSessionContext() {
    }

    private int _count() {
        return this._sessionPool.size();
    }

    private HttpSession _get(String sessionId) {
        if (Validator.isNull(sessionId)) {
            return null;
        }
        return this._sessionPool.get(sessionId);
    }

    private void _put(String sessionId, HttpSession session) {
        this._sessionPool.put(sessionId, session);
    }

    private HttpSession _remove(String sessionId) {
        return this._sessionPool.remove(sessionId);
    }

    private Collection<HttpSession> _values() {
        return this._sessionPool.values();
    }
}

