/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.permission;

import com.liferay.exportimport.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourcePermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;

public abstract class BaseResourcePermissionChecker
implements ResourcePermissionChecker {
    private static final Log _log = LogFactoryUtil.getLog(BaseResourcePermissionChecker.class);

    public static boolean contains(PermissionChecker permissionChecker, String name, long classPK, String actionId) {
        block4: {
            Group group = GroupLocalServiceUtil.fetchGroup(classPK);
            if (group != null && group.isStagingGroup()) {
                classPK = group.getLiveGroupId();
            }
            try {
                int count = ResourcePermissionLocalServiceUtil.getResourcePermissionsCount(permissionChecker.getCompanyId(), name, 4, String.valueOf(classPK));
                if (count == 0) {
                    ResourceLocalServiceUtil.addResources(permissionChecker.getCompanyId(), classPK, 0L, name, classPK, false, true, true);
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn(e, e);
            }
        }
        return permissionChecker.hasPermission(classPK, name, classPK, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, String name, String portletId, long classPK, String actionId) {
        Boolean hasPermission = StagingPermissionUtil.hasPermission(permissionChecker, classPK, name, classPK, portletId, actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        return BaseResourcePermissionChecker.contains(permissionChecker, name, classPK, actionId);
    }
}

