/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auth;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.security.auth.FullNameDefinition;
import com.liferay.portal.kernel.security.auth.FullNameField;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FullNameDefinitionFactory {
    private static final FullNameDefinitionFactory _instance = new FullNameDefinitionFactory();
    private final Map<Locale, FullNameDefinition> _fullNameDefinitions = new ConcurrentHashMap<Locale, FullNameDefinition>();

    public static FullNameDefinition getInstance(Locale locale) {
        return _instance._getInstance(locale);
    }

    private FullNameDefinitionFactory() {
    }

    private FullNameDefinition _getInstance(Locale locale) {
        String[] requiredFieldNames;
        FullNameDefinition fullNameDefinition = this._fullNameDefinitions.get(locale);
        if (fullNameDefinition != null) {
            return fullNameDefinition;
        }
        fullNameDefinition = new FullNameDefinition();
        for (String requiredFieldName : requiredFieldNames = this._getRequiredFieldNames(locale)) {
            fullNameDefinition.addRequiredField(requiredFieldName);
        }
        String[] fieldNames = StringUtil.split(LanguageUtil.get(locale, "lang.user.name.field.names"));
        fieldNames = ArrayUtil.append(requiredFieldNames, fieldNames);
        ArrayUtil.reverse(fieldNames);
        fieldNames = ArrayUtil.unique(fieldNames);
        ArrayUtil.reverse(fieldNames);
        for (String userNameField : fieldNames) {
            FullNameField fullNameField = new FullNameField();
            fullNameField.setName(userNameField);
            String[] values = StringUtil.split(LanguageUtil.get(locale, "lang.user.name." + userNameField + ".values", ""));
            fullNameField.setValues(values);
            fullNameField.setRequired(fullNameDefinition.isFieldRequired(userNameField));
            fullNameDefinition.addFullNameField(fullNameField);
        }
        this._fullNameDefinitions.put(locale, fullNameDefinition);
        return fullNameDefinition;
    }

    private String[] _getRequiredFieldNames(Locale locale) {
        Object[] requiredFieldNames = StringUtil.split(LanguageUtil.get(locale, "lang.user.name.required.field.names"));
        if (!ArrayUtil.contains(requiredFieldNames, "first-name")) {
            requiredFieldNames = (String[])ArrayUtil.append(new String[]{"first-name"}, requiredFieldNames);
        }
        return requiredFieldNames;
    }
}

