/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.dao.search.SearchPaginationUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.HitsImpl;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.SearchResultPermissionFilter;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class BaseSearchResultPermissionFilter
implements SearchResultPermissionFilter {
    private static final double _INDEX_PERMISSION_FILTER_SEARCH_AMPLIFICATION_FACTOR = GetterUtil.getDouble(PropsUtil.get("index.permission.filter.search.amplification.factor"));
    private static final String[] _PERMISSION_SELECTED_FIELD_NAMES = new String[]{"companyId", "entryClassName", "entryClassPK"};

    @Override
    public Hits search(SearchContext searchContext) throws SearchException {
        QueryConfig queryConfig = searchContext.getQueryConfig();
        if (!queryConfig.isAllFieldsSelected()) {
            Set<String> selectedFieldNameSet = SetUtil.fromArray(queryConfig.getSelectedFieldNames());
            Collections.addAll(selectedFieldNameSet, _PERMISSION_SELECTED_FIELD_NAMES);
            queryConfig.setSelectedFieldNames(selectedFieldNameSet.toArray(new String[selectedFieldNameSet.size()]));
        }
        int end = searchContext.getEnd();
        int start = searchContext.getStart();
        if (end == -1 && start == -1) {
            Hits hits = this.getHits(searchContext);
            if (!this.isGroupAdmin(searchContext)) {
                this.filterHits(hits, searchContext);
            }
            return hits;
        }
        if (start < 0 || start > end) {
            return new HitsImpl();
        }
        if (this.isGroupAdmin(searchContext)) {
            return this.getHits(searchContext);
        }
        double amplificationFactor = 1.0;
        int excludedDocsSize = 0;
        int hitsSize = 0;
        int offset = 0;
        long startTime = 0L;
        ArrayList<Document> documents = new ArrayList<Document>();
        ArrayList<Float> scores = new ArrayList<Float>();
        while (true) {
            int count = end - documents.size();
            int amplifiedCount = (int)Math.ceil((double)count * amplificationFactor);
            int amplifiedEnd = offset + amplifiedCount;
            searchContext.setEnd(amplifiedEnd);
            searchContext.setStart(offset);
            Hits hits = this.getHits(searchContext);
            if (startTime == 0L) {
                hitsSize = hits.getLength();
                startTime = hits.getStart();
            }
            Document[] oldDocs = hits.getDocs();
            this.filterHits(hits, searchContext);
            Document[] newDocs = hits.getDocs();
            excludedDocsSize += oldDocs.length - newDocs.length;
            this.collectHits(hits, documents, scores, count);
            if (newDocs.length >= count || oldDocs.length < amplifiedCount || amplifiedEnd >= hitsSize) {
                this.updateHits(hits, documents, scores, start, end, hitsSize - excludedDocsSize, startTime);
                return hits;
            }
            offset = amplifiedEnd;
            amplificationFactor = this._getAmplificationFactor(documents.size(), offset);
        }
    }

    protected void collectHits(Hits hits, List<Document> documents, List<Float> scores, int count) {
        Document[] docs = hits.getDocs();
        if (docs.length < count) {
            count = docs.length;
        }
        for (int i = 0; i < count; ++i) {
            documents.add(docs[i]);
            scores.add(Float.valueOf(hits.score(i)));
        }
    }

    protected abstract void filterHits(Hits var1, SearchContext var2);

    protected abstract Hits getHits(SearchContext var1) throws SearchException;

    protected abstract boolean isGroupAdmin(SearchContext var1);

    protected void updateHits(Hits hits, List<Document> documents, List<Float> scores, int start, int end, int size, long startTime) {
        int[] startAndEnd = SearchPaginationUtil.calculateStartAndEnd(start, end, documents.size());
        start = startAndEnd[0];
        end = startAndEnd[1];
        documents = documents.subList(start, end);
        scores = scores.subList(start, end);
        hits.setDocs(documents.toArray(new Document[documents.size()]));
        hits.setScores(ArrayUtil.toFloatArray(scores));
        hits.setLength(size);
        hits.setSearchTime((float)(System.currentTimeMillis() - startTime) / 1000.0f);
    }

    private double _getAmplificationFactor(double totalViewable, double total) {
        if (totalViewable == 0.0) {
            return _INDEX_PERMISSION_FILTER_SEARCH_AMPLIFICATION_FACTOR;
        }
        return Math.min(1.0 / (totalViewable / total), _INDEX_PERMISSION_FILTER_SEARCH_AMPLIFICATION_FACTOR);
    }
}

