/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.search.OpenSearch;
import com.liferay.portal.kernel.search.OpenSearchUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.service.LayoutServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.util.Date;
import javax.portlet.PortletMode;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;

public abstract class BaseOpenSearchImpl
implements OpenSearch {
    private final boolean _enabled;
    private final String _openSearchDescriptionURL;
    private final String _openSearchURL;

    public BaseOpenSearchImpl() {
        Class<?> clazz = this.getClass();
        this._enabled = GetterUtil.getBoolean(PropsUtil.get(clazz.getName()), true);
        this._openSearchURL = "";
        this._openSearchDescriptionURL = "";
    }

    public BaseOpenSearchImpl(String openSearchURL, String openSearchDescriptionURL) {
        this._openSearchURL = openSearchURL;
        this._openSearchDescriptionURL = openSearchDescriptionURL;
        this._enabled = GetterUtil.getBoolean(PropsUtil.get(ClassUtil.getClassName(this)), true);
    }

    @Override
    public String getClassName() {
        return "";
    }

    @Override
    public boolean isEnabled() {
        return this._enabled;
    }

    @Override
    public abstract String search(HttpServletRequest var1, long var2, long var4, String var6, int var7, int var8, String var9) throws SearchException;

    @Override
    public String search(HttpServletRequest request, long userId, String keywords, int startPage, int itemsPerPage, String format) throws SearchException {
        return this.search(request, 0L, userId, keywords, startPage, itemsPerPage, format);
    }

    @Override
    public String search(HttpServletRequest request, String url) throws SearchException {
        try {
            long userId = PortalUtil.getUserId(request);
            if (userId == 0L) {
                long companyId = PortalUtil.getCompanyId(request);
                userId = UserLocalServiceUtil.getDefaultUserId(companyId);
            }
            String keywords = GetterUtil.getString(HttpUtil.getParameter(url, "keywords", false));
            int startPage = GetterUtil.getInteger(HttpUtil.getParameter(url, "p", false), 1);
            int itemsPerPage = GetterUtil.getInteger(HttpUtil.getParameter(url, "c", false), SearchContainer.DEFAULT_DELTA);
            String format = GetterUtil.getString(HttpUtil.getParameter(url, "format", false));
            return this.search(request, userId, keywords, startPage, itemsPerPage, format);
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    protected void addSearchResult(Element root, long groupId, long scopeGroupId, String entryClassName, long entryClassPK, String title, String link, Date updated, String summary, double score, String format) {
        this.addSearchResult(root, groupId, scopeGroupId, entryClassName, entryClassPK, title, link, updated, summary, new String[0], 0.0, score, format);
    }

    protected void addSearchResult(Element root, long groupId, long scopeGroupId, String entryClassName, long entryClassPK, String title, String link, Date updated, String summary, String[] tags, double ratings, double score, String format) {
        if (format.equals("rss")) {
            this.addSearchResultRSS(root, groupId, scopeGroupId, entryClassName, entryClassPK, title, link, updated, summary, tags, ratings, score);
        } else {
            this.addSearchResultAtom(root, groupId, scopeGroupId, entryClassName, entryClassPK, title, link, updated, summary, tags, ratings, score);
        }
    }

    protected void addSearchResultAtom(Element root, long groupId, long scopeGroupId, String entryClassName, long entryClassPK, String title, String link, Date updated, String summary, String[] tags, double ratings, double score) {
        Element entry = OpenSearchUtil.addElement(root, "entry", 0);
        OpenSearchUtil.addElement(entry, "groupId", 4, groupId);
        OpenSearchUtil.addElement(entry, "scopeGroupId", 4, scopeGroupId);
        OpenSearchUtil.addElement(entry, "entryClassName", 4, entryClassName);
        OpenSearchUtil.addElement(entry, "entryClassPK", 4, entryClassPK);
        OpenSearchUtil.addElement(entry, "title", 0, title);
        Element entryLink = OpenSearchUtil.addElement(entry, "link", 0);
        entryLink.addAttribute("href", link);
        OpenSearchUtil.addElement(entry, "id", 0, "urn:uuid:" + PortalUUIDUtil.generate());
        OpenSearchUtil.addElement(entry, "updated", 0, updated);
        OpenSearchUtil.addElement(entry, "summary", 0, summary);
        OpenSearchUtil.addElement(entry, "tags", 0, StringUtil.merge(tags));
        OpenSearchUtil.addElement(entry, "ratings", 0, ratings);
        OpenSearchUtil.addElement(entry, "score", 2, score);
    }

    protected void addSearchResultRSS(Element root, long groupId, long scopeGroupId, String entryClassName, long entryClassPK, String title, String link, Date updated, String summary, String[] tags, double ratings, double score) {
        Element item = root.addElement("item");
        OpenSearchUtil.addElement(item, "groupId", 4, groupId);
        OpenSearchUtil.addElement(item, "scopeGroupId", 4, scopeGroupId);
        OpenSearchUtil.addElement(item, "entryClassName", 4, entryClassName);
        OpenSearchUtil.addElement(item, "entryClassPK", 4, entryClassPK);
        OpenSearchUtil.addElement(item, "title", 3, title);
        OpenSearchUtil.addElement(item, "link", 3, link);
        OpenSearchUtil.addElement(item, "description", 3, summary);
        OpenSearchUtil.addElement(item, "tags", 3, StringUtil.merge(tags));
        OpenSearchUtil.addElement(item, "ratings", 3, ratings);
        OpenSearchUtil.addElement(item, "score", 2, score);
    }

    protected Object[] addSearchResults(String[] queryTerms, String keywords, int startPage, int itemsPerPage, int total, int start, String title, String searchPath, String format, ThemeDisplay themeDisplay) {
        int totalPages = 0;
        totalPages = total % itemsPerPage == 0 ? total / itemsPerPage : total / itemsPerPage + 1;
        int previousPage = startPage - 1;
        int nextPage = startPage + 1;
        Document doc = SAXReaderUtil.createDocument();
        if (format.equals("rss")) {
            return this.addSearchResultsRSS(doc, queryTerms, keywords, startPage, itemsPerPage, total, start, totalPages, previousPage, nextPage, title, searchPath, themeDisplay);
        }
        return this.addSearchResultsAtom(doc, queryTerms, keywords, startPage, itemsPerPage, total, start, totalPages, previousPage, nextPage, title, searchPath, themeDisplay);
    }

    protected Object[] addSearchResultsAtom(Document doc, String[] queryTerms, String keywords, int startPage, int itemsPerPage, int total, int start, int totalPages, int previousPage, int nextPage, String title, String searchPath, ThemeDisplay themeDisplay) {
        Element root = doc.addElement("feed");
        root.add(OpenSearchUtil.getNamespace(0));
        root.add(OpenSearchUtil.getNamespace(1));
        root.add(OpenSearchUtil.getNamespace(2));
        OpenSearchUtil.addElement(root, "title", 0, title);
        OpenSearchUtil.addElement(root, "updated", 0, new Date());
        Element author = OpenSearchUtil.addElement(root, "author", 0);
        OpenSearchUtil.addElement(author, "name", 0, themeDisplay.getUserId());
        OpenSearchUtil.addElement(root, "id", 0, "urn:uuid:" + PortalUUIDUtil.generate());
        OpenSearchUtil.addElement(root, "queryTerms", 0, StringUtil.merge(queryTerms, ", "));
        OpenSearchUtil.addElement(root, "totalResults", 1, total);
        OpenSearchUtil.addElement(root, "startIndex", 1, start + 1);
        OpenSearchUtil.addElement(root, "itemsPerPage", 1, itemsPerPage);
        Element query = OpenSearchUtil.addElement(root, "Query", 1);
        query.addAttribute("role", "request");
        query.addAttribute("searchTerms", keywords);
        query.addAttribute("startPage", String.valueOf(startPage));
        String searchURL = this.getOpenSearchURL(searchPath, themeDisplay);
        OpenSearchUtil.addLink(root, searchURL, "self", keywords, startPage, itemsPerPage);
        OpenSearchUtil.addLink(root, searchURL, "first", keywords, 1, itemsPerPage);
        if (previousPage > 0) {
            OpenSearchUtil.addLink(root, searchURL, "previous", keywords, previousPage, itemsPerPage);
        }
        if (nextPage <= totalPages) {
            OpenSearchUtil.addLink(root, searchURL, "next", keywords, nextPage, itemsPerPage);
        }
        OpenSearchUtil.addLink(root, searchURL, "last", keywords, totalPages, itemsPerPage);
        Element link = OpenSearchUtil.addElement(root, "link", 0);
        link.addAttribute("rel", "search");
        link.addAttribute("href", this.getOpenSearchDescriptionURL(searchPath, themeDisplay));
        link.addAttribute("type", "application/opensearchdescription+xml");
        return new Object[]{doc, root};
    }

    protected Object[] addSearchResultsRSS(Document doc, String[] queryTerms, String keywords, int startPage, int itemsPerPage, int total, int start, int totalPages, int previousPage, int nextPage, String title, String searchPath, ThemeDisplay themeDisplay) {
        Element root = doc.addElement("rss");
        root.addAttribute("version", "2.0");
        root.add(SAXReaderUtil.createNamespace("atom", "http://www.w3.org/2005/Atom"));
        root.add(OpenSearchUtil.getNamespace(1));
        root.add(OpenSearchUtil.getNamespace(2));
        Element channel = root.addElement("channel");
        OpenSearchUtil.addElement(channel, "title", 3, title);
        OpenSearchUtil.addElement(channel, "link", 3, this.getOpenSearchURL(searchPath, themeDisplay));
        OpenSearchUtil.addElement(channel, "description", 3, title);
        OpenSearchUtil.addElement(channel, "queryTerms", 3, StringUtil.merge(queryTerms, ", "));
        OpenSearchUtil.addElement(channel, "totalResults", 1, total);
        OpenSearchUtil.addElement(channel, "startIndex", 1, start + 1);
        OpenSearchUtil.addElement(channel, "itemsPerPage", 1, itemsPerPage);
        Element query = OpenSearchUtil.addElement(channel, "Query", 1);
        query.addAttribute("role", "request");
        query.addAttribute("searchTerms", keywords);
        query.addAttribute("startPage", String.valueOf(startPage));
        return new Object[]{doc, channel};
    }

    protected String getOpenSearchDescriptionURL(String searchPath, ThemeDisplay themeDisplay) {
        if (Validator.isNotNull(this._openSearchDescriptionURL)) {
            return this._openSearchDescriptionURL;
        }
        return themeDisplay.getPortalURL() + searchPath + "_description.xml";
    }

    protected String getOpenSearchURL(String searchPath, ThemeDisplay themeDisplay) {
        if (Validator.isNotNull(this._openSearchURL)) {
            return this._openSearchURL;
        }
        return themeDisplay.getPortalURL() + searchPath;
    }

    protected long getPlid(HttpServletRequest request, String portletId, long scopeGroupId) throws Exception {
        long plid;
        Layout layout = (Layout)request.getAttribute("LAYOUT");
        long layoutGroupId = scopeGroupId;
        if (layout != null) {
            layoutGroupId = layout.getGroupId();
        }
        if ((plid = LayoutServiceUtil.getDefaultPlid(layoutGroupId, scopeGroupId, false, portletId)) == 0L) {
            plid = LayoutServiceUtil.getDefaultPlid(layoutGroupId, scopeGroupId, true, portletId);
        }
        if (plid == 0L && layout != null) {
            plid = layout.getPlid();
        }
        return plid;
    }

    protected PortletURL getPortletURL(HttpServletRequest request, String portletId) throws Exception {
        return this.getPortletURL(request, portletId, 0L);
    }

    protected PortletURL getPortletURL(HttpServletRequest request, String portletId, long scopeGroupId) throws Exception {
        long plid = this.getPlid(request, portletId, scopeGroupId);
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create(request, portletId, plid, "RENDER_PHASE");
        portletURL.setPortletMode(PortletMode.VIEW);
        portletURL.setWindowState(WindowState.MAXIMIZED);
        return portletURL;
    }

    protected PortletURL getPortletURL(HttpServletRequest request, String className, PortletProvider.Action action, long scopeGroupId) throws Exception {
        LiferayPortletURL portletURL = (LiferayPortletURL)PortletProviderUtil.getPortletURL(request, className, action);
        long plid = this.getPlid(request, portletURL.getPortletId(), scopeGroupId);
        portletURL.setPlid(plid);
        portletURL.setPortletMode(PortletMode.VIEW);
        portletURL.setWindowState(WindowState.MAXIMIZED);
        return portletURL;
    }
}

