/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.search.BaseQueryImpl;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseBooleanQueryImpl
extends BaseQueryImpl
implements BooleanQuery {
    @Override
    public Map<String, Query> addTerms(String[] fields, String values) throws ParseException {
        if (Validator.isNull(values)) {
            return Collections.emptyMap();
        }
        if (fields == null) {
            fields = new String[]{};
        }
        HashMap<String, Query> queries = new HashMap<String, Query>((int)((double)fields.length / 0.75));
        for (String field : fields) {
            Query query = this.addTerm(field, values);
            queries.put(field, query);
        }
        return queries;
    }

    @Override
    public Map<String, Query> addTerms(String[] fields, String value, boolean like) throws ParseException {
        if (Validator.isNull(value)) {
            return Collections.emptyMap();
        }
        HashMap<String, Query> queries = new HashMap<String, Query>((int)((double)fields.length / 0.75));
        for (String field : fields) {
            Query query = this.addTerm(field, value, like);
            queries.put(field, query);
        }
        return queries;
    }

    protected Map<String, List<Query>> addTerms(String[] fields, Map<String, List<String>> termFieldsValuesMap) throws ParseException {
        HashMap<String, List<Query>> queries = new HashMap<String, List<Query>>((int)((double)fields.length / 0.75));
        for (String field : fields) {
            List<String> valuesList = termFieldsValuesMap.get(field);
            ArrayList<Query> queriesList = new ArrayList<Query>(valuesList.size());
            queries.put(field, queriesList);
            for (String value : valuesList) {
                Query query = this.addTerm(field, value);
                queriesList.add(query);
            }
        }
        return queries;
    }

    protected String[] parseKeywords(String values) {
        if (!values.contains("\"")) {
            return StringUtil.split(values, ' ');
        }
        ArrayList<String> keywords = new ArrayList<String>();
        while (values.length() > 0) {
            int pos;
            if (values.startsWith("\"")) {
                if (!(values = values.substring(1)).contains("\"")) continue;
                pos = values.indexOf("\"");
                keywords.add(values.substring(0, pos));
                values = values.substring(pos + 1);
                values = values.trim();
                continue;
            }
            if (values.contains(" ")) {
                pos = values.indexOf(" ");
                keywords.add(values.substring(0, pos));
                values = values.substring(pos + 1);
                values = values.trim();
                continue;
            }
            keywords.add(values);
            break;
        }
        return keywords.toArray(new String[keywords.size()]);
    }
}

