/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.repository.proxy;

import com.liferay.portal.kernel.bean.ClassLoaderBeanHandler;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryEntry;
import com.liferay.portal.kernel.repository.proxy.FileEntryProxyBean;
import com.liferay.portal.kernel.repository.proxy.FileShortcutProxyBean;
import com.liferay.portal.kernel.repository.proxy.FileVersionProxyBean;
import com.liferay.portal.kernel.repository.proxy.FolderProxyBean;
import com.liferay.portal.kernel.repository.proxy.LocalRepositoryProxyBean;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class RepositoryModelProxyBean {
    private final ClassLoader _classLoader;

    public RepositoryModelProxyBean(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    protected FileEntryProxyBean newFileEntryProxyBean(FileEntry fileEntry) {
        if (fileEntry == null) {
            return null;
        }
        FileEntry fileEntryProxy = (FileEntry)this.newProxyInstance(fileEntry, FileEntry.class);
        return new FileEntryProxyBean(fileEntryProxy, this._classLoader);
    }

    protected FileShortcutProxyBean newFileShortcutProxyBean(FileShortcut fileShortcut) {
        if (fileShortcut == null) {
            return null;
        }
        FileShortcut fileShortcutProxy = (FileShortcut)this.newProxyInstance(fileShortcut, FileShortcut.class);
        return new FileShortcutProxyBean(fileShortcutProxy, this._classLoader);
    }

    protected FileVersionProxyBean newFileVersionProxyBean(FileVersion fileVersion) {
        if (fileVersion == null) {
            return null;
        }
        FileVersion fileVersionProxy = (FileVersion)this.newProxyInstance(fileVersion, FileVersion.class);
        return new FileVersionProxyBean(fileVersionProxy, this._classLoader);
    }

    protected FolderProxyBean newFolderProxyBean(Folder folder) {
        if (folder == null) {
            return null;
        }
        Folder folderProxy = (Folder)this.newProxyInstance(folder, Folder.class);
        return new FolderProxyBean(folderProxy, this._classLoader);
    }

    protected LocalRepositoryProxyBean newLocalRepositoryProxyBean(LocalRepository localRepository) {
        LocalRepository localRepositoryProxy = (LocalRepository)this.newProxyInstance(localRepository, LocalRepository.class);
        return new LocalRepositoryProxyBean(localRepositoryProxy, this._classLoader);
    }

    protected Object newProxyBean(Object bean) {
        if (bean instanceof FileEntry) {
            return this.newFileEntryProxyBean((FileEntry)bean);
        }
        if (bean instanceof FileVersion) {
            return this.newFileVersionProxyBean((FileVersion)bean);
        }
        if (bean instanceof Folder) {
            return this.newFolderProxyBean((Folder)bean);
        }
        return bean;
    }

    protected Object newProxyInstance(Object bean, Class<?> clazz) {
        if (bean == null) {
            return null;
        }
        return ProxyUtil.newProxyInstance(this._classLoader, new Class[]{clazz}, new ClassLoaderBeanHandler(bean, this._classLoader));
    }

    protected List<FileEntry> toFileEntryProxyBeans(List<FileEntry> fileEntries) {
        if (fileEntries == null || fileEntries.isEmpty()) {
            return fileEntries;
        }
        ArrayList<FileEntry> fileEntryProxyBeans = new ArrayList<FileEntry>(fileEntries.size());
        for (FileEntry fileEntry : fileEntries) {
            fileEntryProxyBeans.add(this.newFileEntryProxyBean(fileEntry));
        }
        if (ListUtil.isUnmodifiableList(fileEntries)) {
            return Collections.unmodifiableList(fileEntryProxyBeans);
        }
        return fileEntryProxyBeans;
    }

    protected List<FileVersion> toFileVersionProxyBeans(List<FileVersion> fileVersions) {
        if (fileVersions == null || fileVersions.isEmpty()) {
            return fileVersions;
        }
        ArrayList<FileVersion> fileVersionProxyBeans = new ArrayList<FileVersion>(fileVersions.size());
        for (FileVersion fileVersion : fileVersions) {
            fileVersionProxyBeans.add(this.newFileVersionProxyBean(fileVersion));
        }
        if (ListUtil.isUnmodifiableList(fileVersions)) {
            return Collections.unmodifiableList(fileVersionProxyBeans);
        }
        return fileVersionProxyBeans;
    }

    protected List<Folder> toFolderProxyBeans(List<Folder> folders) {
        if (folders == null || folders.isEmpty()) {
            return folders;
        }
        ArrayList<Folder> folderProxyBeans = new ArrayList<Folder>(folders.size());
        for (Folder folder : folders) {
            folderProxyBeans.add(this.newFolderProxyBean(folder));
        }
        if (ListUtil.isUnmodifiableList(folders)) {
            return Collections.unmodifiableList(folderProxyBeans);
        }
        return folderProxyBeans;
    }

    protected List<RepositoryEntry> toObjectProxyBeans(List<RepositoryEntry> repositoryEntries) {
        if (repositoryEntries == null || repositoryEntries.isEmpty()) {
            return repositoryEntries;
        }
        ArrayList<RepositoryEntry> objectProxyBeans = new ArrayList<RepositoryEntry>();
        for (RepositoryEntry repositoryEntry : repositoryEntries) {
            objectProxyBeans.add((RepositoryEntry)this.newProxyBean(repositoryEntry));
        }
        if (ListUtil.isUnmodifiableList(repositoryEntries)) {
            return Collections.unmodifiableList(objectProxyBeans);
        }
        return objectProxyBeans;
    }
}

