/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.nio.intraband.welder;

import com.liferay.portal.kernel.nio.intraband.Intraband;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.welder.Welder;
import java.io.IOException;
import java.io.ObjectInputStream;

public abstract class BaseWelder
implements Welder {
    protected transient RegistrationReference registrationReference;
    protected final transient boolean server;
    protected transient State state = State.CREATED;

    public BaseWelder() {
        this.server = true;
    }

    @Override
    public synchronized void destroy() throws IOException {
        if (this.state != State.WELDED) {
            throw new IllegalStateException("Unable to destroy a welder with state " + (Object)((Object)this.state));
        }
        this.registrationReference.cancelRegistration();
        this.doDestroy();
        this.state = State.DESTROYED;
    }

    @Override
    public synchronized RegistrationReference weld(Intraband intraband) throws IOException {
        if (this.state != State.CREATED) {
            throw new IllegalStateException("Unable to weld a welder with state " + (Object)((Object)this.state));
        }
        this.registrationReference = this.server ? this.weldServer(intraband) : this.weldClient(intraband);
        this.state = State.WELDED;
        return this.registrationReference;
    }

    protected abstract void doDestroy() throws IOException;

    protected abstract RegistrationReference weldClient(Intraband var1) throws IOException;

    protected abstract RegistrationReference weldServer(Intraband var1) throws IOException;

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.state = State.CREATED;
    }

    protected static enum State {
        CREATED,
        DESTROYED,
        WELDED;

    }
}

