/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageListenerException;

public class InvokerMessageListener
implements MessageListener {
    private final ClassLoader _classLoader;
    private final MessageListener _messageListener;

    public InvokerMessageListener(MessageListener messageListener) {
        this(messageListener, Thread.currentThread().getContextClassLoader());
    }

    public InvokerMessageListener(MessageListener messageListener, ClassLoader classLoader) {
        this._messageListener = messageListener;
        this._classLoader = classLoader;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InvokerMessageListener)) {
            return false;
        }
        InvokerMessageListener messageListenerInvoker = (InvokerMessageListener)obj;
        return this._messageListener.equals(messageListenerInvoker.getMessageListener());
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public MessageListener getMessageListener() {
        return this._messageListener;
    }

    public int hashCode() {
        return this._messageListener.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(Message message) throws MessageListenerException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        if (this._classLoader != null) {
            currentThread.setContextClassLoader(this._classLoader);
        }
        try {
            this._messageListener.receive(message);
        }
        finally {
            if (this._classLoader != null) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    public String toString() {
        return this._messageListener.toString();
    }
}

