/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.lock;

import com.liferay.portal.kernel.lock.LockListener;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.util.HashMap;
import java.util.Map;

public class LockListenerRegistryUtil {
    private static final LockListenerRegistryUtil _instance = new LockListenerRegistryUtil();
    private final Map<String, LockListener> _lockListeners = new HashMap<String, LockListener>();
    private final ServiceTracker<?, LockListener> _serviceTracker;

    public static LockListener getLockListener(String className) {
        return LockListenerRegistryUtil._instance._lockListeners.get(className);
    }

    private LockListenerRegistryUtil() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(LockListener.class, (ServiceTrackerCustomizer)new LockListenerServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    private class LockListenerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<LockListener, LockListener> {
        private LockListenerServiceTrackerCustomizer() {
        }

        public LockListener addingService(ServiceReference<LockListener> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            LockListener lockListener = (LockListener)registry.getService(serviceReference);
            LockListenerRegistryUtil.this._lockListeners.put(lockListener.getClassName(), lockListener);
            return lockListener;
        }

        public void modifiedService(ServiceReference<LockListener> serviceReference, LockListener lockListener) {
        }

        public void removedService(ServiceReference<LockListener> serviceReference, LockListener lockListener) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            LockListenerRegistryUtil.this._lockListeners.remove(lockListener);
        }
    }
}

