/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.executor;

import com.liferay.portal.kernel.concurrent.ThreadPoolExecutor;
import com.liferay.portal.kernel.executor.PortalExecutorManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceTracker;

public class PortalExecutorManagerUtil {
    private static final Log _log = LogFactoryUtil.getLog(PortalExecutorManagerUtil.class);
    private static final PortalExecutorManagerUtil _instance = new PortalExecutorManagerUtil();
    private final ServiceTracker<PortalExecutorManager, PortalExecutorManager> _serviceTracker;

    public static ThreadPoolExecutor getPortalExecutor(String name) {
        PortalRuntimePermission.checkThreadPoolExecutor(name);
        return PortalExecutorManagerUtil.getPortalExecutorManager().getPortalExecutor(name);
    }

    public static ThreadPoolExecutor getPortalExecutor(String name, boolean createIfAbsent) {
        PortalRuntimePermission.checkThreadPoolExecutor(name);
        return PortalExecutorManagerUtil.getPortalExecutorManager().getPortalExecutor(name, createIfAbsent);
    }

    public static PortalExecutorManager getPortalExecutorManager() {
        PortalRuntimePermission.checkGetBeanProperty(PortalExecutorManagerUtil.class);
        try {
            while (PortalExecutorManagerUtil._instance._serviceTracker.getService() == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Waiting for a PortalExecutorManager");
                }
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return (PortalExecutorManager)PortalExecutorManagerUtil._instance._serviceTracker.getService();
    }

    public static ThreadPoolExecutor registerPortalExecutor(String name, ThreadPoolExecutor threadPoolExecutor) {
        PortalRuntimePermission.checkThreadPoolExecutor(name);
        return PortalExecutorManagerUtil.getPortalExecutorManager().registerPortalExecutor(name, threadPoolExecutor);
    }

    public static void shutdown() {
        PortalRuntimePermission.checkThreadPoolExecutor("<<ALL EXECUTORS>>");
        PortalExecutorManager portalExecutorManager = (PortalExecutorManager)PortalExecutorManagerUtil._instance._serviceTracker.getService();
        if (portalExecutorManager == null) {
            return;
        }
        portalExecutorManager.shutdown();
    }

    public static void shutdown(boolean interrupt) {
        PortalRuntimePermission.checkThreadPoolExecutor("<<ALL EXECUTORS>>");
        PortalExecutorManager portalExecutorManager = (PortalExecutorManager)PortalExecutorManagerUtil._instance._serviceTracker.getService();
        if (portalExecutorManager == null) {
            return;
        }
        portalExecutorManager.shutdown(interrupt);
    }

    private PortalExecutorManagerUtil() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(PortalExecutorManager.class);
        this._serviceTracker.open();
    }
}

