/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cluster;

import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterInvokeAcceptor;
import com.liferay.portal.kernel.cluster.ClusterInvokeAcceptorUtil;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.ClusterableContextThreadLocal;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiServiceInvokerUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class ClusterableInvokerUtil {
    private static final long _CLUSTERABLE_ADVICE_CALL_MASTER_TIMEOUT = GetterUtil.getLong(PropsUtil.get("clusterable.advice.call.master.timeout"));
    private static final MethodKey _invokeMethodKey = new MethodKey(ClusterableInvokerUtil.class, "_invoke", MethodHandler.class, String.class, Map.class);

    public static MethodHandler createMethodHandler(Class<? extends ClusterInvokeAcceptor> clusterInvokeAcceptorClass, Object targetObject, Method method, Object[] arguments) {
        MethodHandler methodHandler = IdentifiableOSGiServiceInvokerUtil.createMethodHandler(targetObject, method, arguments);
        Map<String, Serializable> context = ClusterableContextThreadLocal.collectThreadLocalContext();
        ClusterableInvokerUtil._populateContextFromThreadLocals(context);
        String clusterInvokeAcceptorClassName = clusterInvokeAcceptorClass.getName();
        if (clusterInvokeAcceptorClass == ClusterInvokeAcceptor.class) {
            clusterInvokeAcceptorClassName = null;
        }
        return new MethodHandler(_invokeMethodKey, methodHandler, clusterInvokeAcceptorClassName, context);
    }

    public static void invokeOnCluster(Class<? extends ClusterInvokeAcceptor> clusterInvokeAcceptorClass, Object targetObject, Method method, Object[] arguments) throws Throwable {
        MethodHandler methodHandler = ClusterableInvokerUtil.createMethodHandler(clusterInvokeAcceptorClass, targetObject, method, arguments);
        ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest(methodHandler, true);
        clusterRequest.setFireAndForget(true);
        ClusterExecutorUtil.execute(clusterRequest);
    }

    public static Object invokeOnMaster(Class<? extends ClusterInvokeAcceptor> clusterInvokeAcceptorClass, Object targetObject, Method method, Object[] arguments) throws Throwable {
        MethodHandler methodHandler = ClusterableInvokerUtil.createMethodHandler(clusterInvokeAcceptorClass, targetObject, method, arguments);
        Future futureResult = ClusterMasterExecutorUtil.executeOnMaster(methodHandler);
        return futureResult.get(_CLUSTERABLE_ADVICE_CALL_MASTER_TIMEOUT, TimeUnit.SECONDS);
    }

    private static Object _invoke(MethodHandler methodHandler, String clusterInvokeAcceptorClassName, Map<String, Serializable> context) throws Exception {
        ClusterInvokeAcceptor clusterInvokeAcceptor;
        if (Validator.isNotNull(clusterInvokeAcceptorClassName) && !(clusterInvokeAcceptor = ClusterInvokeAcceptorUtil.getClusterInvokeAcceptor(clusterInvokeAcceptorClassName)).accept(context)) {
            return null;
        }
        ClusterableInvokerUtil._populateThreadLocalsFromContext(context);
        return methodHandler.invoke();
    }

    private static void _populateContextFromThreadLocals(Map<String, Serializable> context) {
        if (!context.containsKey("companyId")) {
            context.put("companyId", CompanyThreadLocal.getCompanyId());
        }
        if (!context.containsKey("defaultLocale")) {
            context.put("defaultLocale", LocaleThreadLocal.getDefaultLocale());
        }
        if (!context.containsKey("groupId")) {
            context.put("groupId", GroupThreadLocal.getGroupId());
        }
        if (!context.containsKey("principalName")) {
            context.put("principalName", (Serializable)((Object)PrincipalThreadLocal.getName()));
        }
        if (!context.containsKey("principalPassword")) {
            context.put("principalPassword", (Serializable)((Object)PrincipalThreadLocal.getPassword()));
        }
        if (!context.containsKey("siteDefaultLocale")) {
            context.put("siteDefaultLocale", LocaleThreadLocal.getSiteDefaultLocale());
        }
        if (!context.containsKey("themeDisplayLocale")) {
            context.put("themeDisplayLocale", LocaleThreadLocal.getThemeDisplayLocale());
        }
    }

    private static void _populateThreadLocalsFromContext(Map<String, Serializable> context) {
        Locale themeDisplayLocale;
        Locale siteDefaultLocale;
        String principalPassword;
        String principalName;
        long groupId;
        Locale defaultLocale;
        long companyId = GetterUtil.getLong(context.get("companyId"));
        if (companyId > 0L) {
            CompanyThreadLocal.setCompanyId(companyId);
        }
        if ((defaultLocale = (Locale)context.get("defaultLocale")) != null) {
            LocaleThreadLocal.setDefaultLocale(defaultLocale);
        }
        if ((groupId = GetterUtil.getLong(context.get("groupId"))) > 0L) {
            GroupThreadLocal.setGroupId(groupId);
        }
        if (Validator.isNotNull(principalName = GetterUtil.getString(context.get("principalName")))) {
            PrincipalThreadLocal.setName(principalName);
        }
        PermissionChecker permissionChecker = null;
        if (Validator.isNotNull(principalName)) {
            try {
                User user = UserLocalServiceUtil.fetchUser(PrincipalThreadLocal.getUserId());
                permissionChecker = PermissionCheckerFactoryUtil.create(user);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (permissionChecker != null) {
            PermissionThreadLocal.setPermissionChecker(permissionChecker);
        }
        if (Validator.isNotNull(principalPassword = GetterUtil.getString(context.get("principalPassword")))) {
            PrincipalThreadLocal.setPassword(principalPassword);
        }
        if ((siteDefaultLocale = (Locale)context.get("siteDefaultLocale")) != null) {
            LocaleThreadLocal.setSiteDefaultLocale(siteDefaultLocale);
        }
        if ((themeDisplayLocale = (Locale)context.get("themeDisplayLocale")) != null) {
            LocaleThreadLocal.setThemeDisplayLocale(themeDisplayLocale);
        }
    }
}

