/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cal;

import com.liferay.portal.kernel.cal.DayAndPosition;
import com.liferay.portal.kernel.cal.Duration;
import com.liferay.portal.kernel.cal.Recurrence;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class TZSRecurrence
extends Recurrence {
    private TimeZone _timeZone;

    public TZSRecurrence() {
    }

    public TZSRecurrence(Calendar startCalendar, Duration duration) {
        super(startCalendar, duration);
    }

    public TZSRecurrence(Calendar startCalendar, Duration duration, int frequency) {
        super(startCalendar, duration, frequency);
    }

    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this._timeZone = timeZone == null ? null : TimeZoneUtil.getTimeZone(timeZone.getID());
    }

    protected Calendar getAdjustedCalendar(Calendar candidateCalendar) {
        if (this._timeZone == null) {
            return candidateCalendar;
        }
        GregorianCalendar adjustedCalendar = new GregorianCalendar(this._timeZone);
        Date candidateDate = candidateCalendar.getTime();
        long dailightSavingsTimeDelta = this._timeZone.getOffset(candidateCalendar.getTimeInMillis()) - this._timeZone.getOffset(this.dtStart.getTimeInMillis());
        adjustedCalendar.setTimeInMillis(candidateDate.getTime() - dailightSavingsTimeDelta);
        return adjustedCalendar;
    }

    @Override
    protected boolean matchesByField(int[] array, int field, Calendar candidateCalendar, boolean allowNegative) {
        Calendar adjustedCandidate = this.getAdjustedCalendar(candidateCalendar);
        return super.matchesByField(array, field, adjustedCandidate, allowNegative);
    }

    @Override
    protected boolean matchesByMonth(Calendar candidateCalendar) {
        return this.matchesByField(this.byMonth, 2, candidateCalendar, false);
    }

    @Override
    protected boolean matchesByMonthDay(Calendar candidateCalendar) {
        return this.matchesByField(this.byMonthDay, 5, candidateCalendar, true);
    }

    @Override
    protected boolean matchesByWeekNo(Calendar candidateCalendar) {
        return this.matchesByField(this.byWeekNo, 3, candidateCalendar, true);
    }

    @Override
    protected boolean matchesByYearDay(Calendar candidateCalendar) {
        return this.matchesByField(this.byYearDay, 6, candidateCalendar, true);
    }

    @Override
    protected boolean matchesIndividualByDay(Calendar candidateCalendar, DayAndPosition dayAndPosition) {
        Calendar adjustedCandidate = this.getAdjustedCalendar(candidateCalendar);
        return super.matchesIndividualByDay(adjustedCandidate, dayAndPosition);
    }
}

