/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.social.kernel.model.SocialRequest;
import com.liferay.social.kernel.service.SocialRequestLocalServiceUtil;
import com.liferay.social.kernel.service.permission.SocialRequestPermission;

public class SocialRequestPermissionImpl
implements SocialRequestPermission {
    public void check(PermissionChecker permissionChecker, long requestId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, requestId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, SocialRequest.class.getName(), requestId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, long requestId, String actionId) throws PortalException {
        if (permissionChecker.isOmniadmin()) {
            return true;
        }
        if (actionId.equals("UPDATE")) {
            SocialRequest request = SocialRequestLocalServiceUtil.getSocialRequest((long)requestId);
            if (permissionChecker.getUserId() == request.getReceiverUserId()) {
                return true;
            }
        }
        return false;
    }
}

