/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.permission;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.service.permission.AssetPermission;
import com.liferay.portlet.asset.service.permission.AssetVocabularyPermission;

public class AssetCategoryPermission {
    public static void check(PermissionChecker permissionChecker, AssetCategory category, String actionId) throws PortalException {
        if (!AssetCategoryPermission.contains(permissionChecker, category, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, AssetCategory.class.getName(), category.getCategoryId(), new String[]{actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, long categoryId, String actionId) throws PortalException {
        if (!AssetCategoryPermission.contains(permissionChecker, groupId, categoryId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, AssetCategory.class.getName(), categoryId, new String[]{actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, long categoryId, String actionId) throws PortalException {
        if (!AssetCategoryPermission.contains(permissionChecker, categoryId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, AssetCategory.class.getName(), categoryId, new String[]{actionId});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, AssetCategory category, String actionId) throws PortalException {
        if (actionId.equals("VIEW") && !AssetVocabularyPermission.contains(permissionChecker, category.getVocabularyId(), "VIEW")) {
            return false;
        }
        if (actionId.equals("VIEW") && PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) {
            long categoryId = category.getCategoryId();
            while (categoryId != 0L) {
                category = AssetCategoryLocalServiceUtil.getCategory((long)categoryId);
                if (!AssetCategoryPermission._hasPermission(permissionChecker, category, actionId)) {
                    return false;
                }
                categoryId = category.getParentCategoryId();
            }
            return AssetVocabularyPermission.contains(permissionChecker, category.getVocabularyId(), actionId);
        }
        return AssetCategoryPermission._hasPermission(permissionChecker, category, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, long categoryId, String actionId) throws PortalException {
        if (categoryId == 0L) {
            return AssetPermission.contains(permissionChecker, groupId, actionId);
        }
        return AssetCategoryPermission.contains(permissionChecker, categoryId, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long categoryId, String actionId) throws PortalException {
        AssetCategory category = AssetCategoryLocalServiceUtil.getCategory((long)categoryId);
        return AssetCategoryPermission.contains(permissionChecker, category, actionId);
    }

    private static boolean _hasPermission(PermissionChecker permissionChecker, AssetCategory category, String actionId) {
        return permissionChecker.hasOwnerPermission(category.getCompanyId(), AssetCategory.class.getName(), category.getCategoryId(), category.getUserId(), actionId) || permissionChecker.hasPermission(category.getGroupId(), AssetCategory.class.getName(), category.getCategoryId(), actionId);
    }
}

