/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.GroupFriendlyURLException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.UserGroupGroupRole;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupGroupRoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.RobotsUtil;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class VerifyGroup
extends VerifyProcess {
    private static final String[] _LEGACY_STAGED_PORTLET_TYPE_SETTINGS_KEYS = new String[]{"staged-portlet_39", "staged-portlet_54", "staged-portlet_56", "staged-portlet_59", "staged-portlet_107", "staged-portlet_108", "staged-portlet_110", "staged-portlet_166", "staged-portlet_169"};
    private static final Log _log = LogFactoryUtil.getLog(VerifyGroup.class);

    @Override
    protected void doVerify() throws Exception {
        this.verifyCompanyGroups();
        this.verifyNullFriendlyURLGroups();
        this.verifyOrganizationNames();
        this.verifyRobots();
        this.verifySites();
        this.verifyStagedGroups();
        this.verifyTree();
    }

    protected String getRobots(LayoutSet layoutSet) {
        if (layoutSet == null) {
            return RobotsUtil.getDefaultRobots(null);
        }
        String virtualHostname = "";
        try {
            virtualHostname = layoutSet.getVirtualHostname();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return GetterUtil.get((String)layoutSet.getSettingsProperty(layoutSet.isPrivateLayout() + "-robots.txt"), (String)RobotsUtil.getDefaultRobots(virtualHostname));
    }

    protected void updateName(long groupId, String name) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("update Group_ set name = ? where groupId= " + groupId);){
            ps.setString(1, name);
            ps.executeUpdate();
        }
    }

    protected void verifyCompanyGroups() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List companies = CompanyLocalServiceUtil.getCompanies();
            for (Company company : companies) {
                GroupLocalServiceUtil.checkCompanyGroup((long)company.getCompanyId());
                GroupLocalServiceUtil.checkSystemGroups((long)company.getCompanyId());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void verifyNullFriendlyURLGroups() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List groups = GroupLocalServiceUtil.getNullFriendlyURLGroups();
            for (Group group : groups) {
                String friendlyURL = "/" + group.getGroupId();
                User user = null;
                if (group.isCompany() && !group.isCompanyStagingGroup()) {
                    friendlyURL = "/global";
                } else if (group.isUser()) {
                    user = UserLocalServiceUtil.getUserById((long)group.getClassPK());
                    friendlyURL = "/" + user.getScreenName();
                } else if (group.getClassPK() > 0L) {
                    friendlyURL = "/" + group.getClassPK();
                }
                try {
                    GroupLocalServiceUtil.updateFriendlyURL((long)group.getGroupId(), (String)friendlyURL);
                }
                catch (GroupFriendlyURLException gfurle) {
                    if (user != null) {
                        long userId = user.getUserId();
                        String screenName = user.getScreenName();
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)("Updating user screen name " + screenName + " to " + userId + " because it is " + "generating an invalid friendly URL " + friendlyURL));
                        }
                        UserLocalServiceUtil.updateScreenName((long)userId, (String)String.valueOf(userId));
                        continue;
                    }
                    _log.error((Object)("Invalid Friendly URL " + friendlyURL));
                    throw gfurle;
                    return;
                }
            }
        }
    }

    protected void verifyOrganizationNames() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            StringBundler sb = new StringBundler(5);
            sb.append("select groupId, name from Group_ where name like '%");
            sb.append(" LFR_ORGANIZATION");
            sb.append("%' and name not like '%");
            sb.append(" LFR_ORGANIZATION");
            sb.append("'");
            try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long groupId = rs.getLong("groupId");
                    String name = rs.getString("name");
                    if (name.endsWith(" LFR_ORGANIZATION") || name.endsWith(" (Staging)")) continue;
                    int pos = name.indexOf(" LFR_ORGANIZATION");
                    pos = name.indexOf(" ", pos + 1);
                    String newName = name.substring(pos + 1) + " LFR_ORGANIZATION";
                    this.updateName(groupId, newName);
                }
            }
        }
    }

    protected void verifyRobots() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List groups = GroupLocalServiceUtil.getLiveGroups();
            for (Group group : groups) {
                LayoutSet privateLayoutSet = group.getPrivateLayoutSet();
                LayoutSet publicLayoutSet = group.getPublicLayoutSet();
                String privateLayoutSetRobots = this.getRobots(privateLayoutSet);
                String publicLayoutSetRobots = this.getRobots(publicLayoutSet);
                UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
                typeSettingsProperties.setProperty("true-robots.txt", privateLayoutSetRobots);
                typeSettingsProperties.setProperty("false-robots.txt", publicLayoutSetRobots);
                GroupLocalServiceUtil.updateGroup((long)group.getGroupId(), (String)typeSettingsProperties.toString());
            }
        }
    }

    protected void verifySites() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(Group.class);
            dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"classNameId", (Object)PortalUtil.getClassNameId(Organization.class)));
            dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"site", (Object)false));
            List groups = GroupLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
            for (Group group : groups) {
                if (group.getPrivateLayoutsPageCount() <= 0 && group.getPublicLayoutsPageCount() <= 0) continue;
                group.setSite(true);
                GroupLocalServiceUtil.updateGroup((Group)group);
            }
        }
    }

    protected void verifyStagedGroups() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List groups = GroupLocalServiceUtil.getLiveGroups();
            for (Group group : groups) {
                if (!group.hasStagingGroup()) continue;
                UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
                typeSettingsProperties.setProperty("staged", Boolean.TRUE.toString());
                typeSettingsProperties.setProperty("stagedRemotely", Boolean.FALSE.toString());
                this.verifyStagingTypeSettingsProperties(typeSettingsProperties);
                GroupLocalServiceUtil.updateGroup((long)group.getGroupId(), (String)typeSettingsProperties.toString());
                Group stagingGroup = group.getStagingGroup();
                if (group.getClassNameId() != stagingGroup.getClassNameId()) {
                    stagingGroup.setClassNameId(group.getClassNameId());
                    GroupLocalServiceUtil.updateGroup((Group)stagingGroup);
                }
                if (stagingGroup.isStagedRemotely()) continue;
                this.verifyStagingGroupOrganizationMembership(stagingGroup);
                this.verifyStagingGroupRoleMembership(stagingGroup);
                this.verifyStagingGroupUserGroupMembership(stagingGroup);
                this.verifyStagingGroupUserMembership(stagingGroup);
                this.verifyStagingUserGroupRolesAssignments(stagingGroup);
                this.verifyStagingUserGroupGroupRolesAssignments(stagingGroup);
            }
        }
    }

    protected void verifyStagingGroupOrganizationMembership(Group stagingGroup) throws Exception {
        List stagingOrganizations = OrganizationLocalServiceUtil.getGroupOrganizations((long)stagingGroup.getGroupId());
        if (ListUtil.isEmpty((List)stagingOrganizations)) {
            return;
        }
        List liveOrganizations = OrganizationLocalServiceUtil.getGroupOrganizations((long)stagingGroup.getLiveGroupId());
        for (Organization stagingGroupOrganization : stagingOrganizations) {
            if (liveOrganizations.contains(stagingGroupOrganization)) continue;
            OrganizationLocalServiceUtil.addGroupOrganization((long)stagingGroup.getLiveGroupId(), (Organization)stagingGroupOrganization);
        }
        OrganizationLocalServiceUtil.clearGroupOrganizations((long)stagingGroup.getGroupId());
    }

    protected void verifyStagingGroupRoleMembership(Group stagingGroup) {
        List stagingRoles = RoleLocalServiceUtil.getGroupRoles((long)stagingGroup.getGroupId());
        if (ListUtil.isEmpty((List)stagingRoles)) {
            return;
        }
        List liveRoles = RoleLocalServiceUtil.getGroupRoles((long)stagingGroup.getLiveGroupId());
        for (Role stagingRole : stagingRoles) {
            if (liveRoles.contains(stagingRole)) continue;
            RoleLocalServiceUtil.addGroupRole((long)stagingGroup.getLiveGroupId(), (Role)stagingRole);
        }
        RoleLocalServiceUtil.clearGroupRoles((long)stagingGroup.getGroupId());
    }

    protected void verifyStagingGroupUserGroupMembership(Group stagingGroup) {
        List stagingUserGroups = UserGroupLocalServiceUtil.getGroupUserGroups((long)stagingGroup.getGroupId());
        if (ListUtil.isEmpty((List)stagingUserGroups)) {
            return;
        }
        List liveUserGroups = UserGroupLocalServiceUtil.getGroupUserGroups((long)stagingGroup.getLiveGroupId());
        for (UserGroup stagingUserGroup : stagingUserGroups) {
            if (liveUserGroups.contains(stagingUserGroup)) continue;
            UserGroupLocalServiceUtil.addGroupUserGroup((long)stagingGroup.getLiveGroupId(), (UserGroup)stagingUserGroup);
        }
        UserGroupLocalServiceUtil.clearGroupUserGroups((long)stagingGroup.getGroupId());
    }

    protected void verifyStagingGroupUserMembership(Group stagingGroup) {
        List stagingGroupUsers = UserLocalServiceUtil.getGroupUsers((long)stagingGroup.getGroupId());
        if (ListUtil.isEmpty((List)stagingGroupUsers)) {
            return;
        }
        List liveGroupUsers = UserLocalServiceUtil.getGroupUsers((long)stagingGroup.getLiveGroupId());
        for (User stagingGroupUser : stagingGroupUsers) {
            if (liveGroupUsers.contains(stagingGroupUser)) continue;
            UserLocalServiceUtil.addGroupUser((long)stagingGroup.getLiveGroupId(), (User)stagingGroupUser);
        }
        UserLocalServiceUtil.clearGroupUsers((long)stagingGroup.getGroupId());
    }

    protected void verifyStagingTypeSettingsProperties(UnicodeProperties typeSettingsProperties) {
        Set keys = typeSettingsProperties.keySet();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (!ArrayUtil.contains((Object[])_LEGACY_STAGED_PORTLET_TYPE_SETTINGS_KEYS, (Object)key)) continue;
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Removing type settings property " + key));
            }
            iterator.remove();
        }
    }

    protected void verifyStagingUserGroupGroupRolesAssignments(Group stagingGroup) {
        DynamicQuery dynamicQuery = UserGroupGroupRoleLocalServiceUtil.dynamicQuery();
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"id.groupId", (Object)stagingGroup.getGroupId()));
        List stagingUserGroupGroupRoles = UserGroupGroupRoleLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        if (stagingUserGroupGroupRoles.isEmpty()) {
            return;
        }
        dynamicQuery = UserGroupGroupRoleLocalServiceUtil.dynamicQuery();
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"id.groupId", (Object)stagingGroup.getLiveGroupId()));
        List liveUserGroupGroupRoles = UserGroupGroupRoleLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        for (UserGroupGroupRole userGroupGroupRole : stagingUserGroupGroupRoles) {
            userGroupGroupRole.setGroupId(stagingGroup.getLiveGroupId());
            if (liveUserGroupGroupRoles.contains(userGroupGroupRole)) continue;
            UserGroupGroupRoleLocalServiceUtil.updateUserGroupGroupRole((UserGroupGroupRole)userGroupGroupRole);
        }
        UserGroupGroupRoleLocalServiceUtil.deleteUserGroupGroupRolesByGroupId((long)stagingGroup.getGroupId());
    }

    protected void verifyStagingUserGroupRolesAssignments(Group stagingGroup) {
        List stagingUserGroupRoles = UserGroupRoleLocalServiceUtil.getUserGroupRolesByGroup((long)stagingGroup.getGroupId());
        if (ListUtil.isEmpty((List)stagingUserGroupRoles)) {
            return;
        }
        List liveUserGroupRoles = UserGroupRoleLocalServiceUtil.getUserGroupRolesByGroup((long)stagingGroup.getLiveGroupId());
        for (UserGroupRole stagingUserGroupRole : stagingUserGroupRoles) {
            stagingUserGroupRole.setGroupId(stagingGroup.getLiveGroupId());
            if (liveUserGroupRoles.contains(stagingUserGroupRole)) continue;
            UserGroupRoleLocalServiceUtil.updateUserGroupRole((UserGroupRole)stagingUserGroupRole);
        }
        UserGroupRoleLocalServiceUtil.deleteUserGroupRolesByGroupId((long)stagingGroup.getGroupId());
    }

    protected void verifyTree() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long[] companyIds;
            for (long companyId : companyIds = PortalInstances.getCompanyIdsBySQL()) {
                GroupLocalServiceUtil.rebuildTree((long)companyId);
            }
        }
    }
}

