/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.upgrade.AutoBatchPreparedStatementUtil;
import com.liferay.util.xml.XMLUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Iterator;

public class UpgradePortalPreferences
extends UpgradeProcess {
    protected String convertStagingPreferencesToJSON(String preferences) throws Exception {
        Document newDocument = SAXReaderUtil.createDocument();
        Element newRootElement = SAXReaderUtil.createElement((String)"portlet-preferences");
        newDocument.add(newRootElement);
        Document document = SAXReaderUtil.read((String)preferences);
        Element rootElement = document.getRootElement();
        Iterator iterator = rootElement.elementIterator();
        while (iterator.hasNext()) {
            Element preferenceElement = (Element)iterator.next();
            String preferenceName = preferenceElement.elementText("name");
            if (preferenceName.contains("com.liferay.portlet.kernel.staging.Staging")) continue;
            newRootElement.add(preferenceElement.createCopy());
        }
        return XMLUtil.formatXML((Document)newDocument);
    }

    protected void doUpgrade() throws Exception {
        this.upgradeStagingPortalPreferences();
    }

    protected void upgradeStagingPortalPreferences() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps1 = this.connection.prepareStatement("select portalPreferencesId, preferences from PortalPreferences");
             ResultSet rs = ps1.executeQuery();
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.autoBatch(this.connection.prepareStatement("update PortalPreferences set preferences = ? where portalPreferencesId = ?"));){
            while (rs.next()) {
                long portalPreferencesId = rs.getLong("portalPreferencesId");
                String preferences = rs.getString("preferences");
                ps2.setString(1, this.convertStagingPreferencesToJSON(preferences));
                ps2.setLong(2, portalPreferencesId);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }
}

